/*
 * Decompiled with CFR 0.152.
 */
package swim.structure.selector;

import java.util.ListIterator;
import swim.codec.Output;
import swim.structure.Field;
import swim.structure.Interpreter;
import swim.structure.Item;
import swim.structure.Record;
import swim.structure.Selectee;
import swim.structure.Selector;
import swim.structure.Value;
import swim.util.Murmur3;

public class ValuesSelector
extends Selector {
    final Selector then;
    private static int hashSeed;

    public ValuesSelector(Selector then) {
        this.then = then;
    }

    @Override
    public Selector then() {
        return this.then;
    }

    @Override
    public <T> T forSelected(Interpreter interpreter, Selectee<T> callback) {
        T selected = null;
        interpreter.willSelect(this);
        if (interpreter.scopeDepth() != 0) {
            Item scope = interpreter.popScope();
            if (scope instanceof Record) {
                ListIterator<Item> children = ((Record)scope).listIterator();
                while (selected == null && children.hasNext()) {
                    Item child = children.next();
                    interpreter.pushScope(child.toValue());
                    selected = this.then.forSelected(interpreter, callback);
                    interpreter.popScope();
                }
            } else {
                interpreter.pushScope(scope.toValue());
                selected = this.then.forSelected(interpreter, callback);
                interpreter.popScope();
            }
            interpreter.pushScope(scope);
        }
        interpreter.didSelect(this, selected);
        return selected;
    }

    @Override
    public Item mapSelected(Interpreter interpreter, Selectee<Item> transform) {
        Item result;
        interpreter.willTransform(this);
        if (interpreter.scopeDepth() != 0) {
            Item scope = interpreter.popScope();
            if (scope instanceof Record) {
                ListIterator<Item> children = ((Record)scope).listIterator();
                while (children.hasNext()) {
                    Item child = children.next();
                    if (child instanceof Field) {
                        Value oldValue = child.toValue();
                        interpreter.pushScope(oldValue);
                        Item newItem = this.then.mapSelected(interpreter, transform);
                        interpreter.popScope();
                        if (newItem.isDefined()) {
                            if (newItem instanceof Field) {
                                children.set(newItem);
                                continue;
                            }
                            if (newItem == oldValue) continue;
                            children.set(((Field)child).updatedValue(newItem.toValue()));
                            continue;
                        }
                        children.remove();
                        continue;
                    }
                    interpreter.pushScope(child.toValue());
                    Item newItem = this.then.mapSelected(interpreter, transform);
                    interpreter.popScope();
                    if (newItem.isDefined()) {
                        if (child == newItem) continue;
                        children.set(newItem);
                        continue;
                    }
                    children.remove();
                }
            } else if (scope instanceof Field) {
                Value oldValue = scope.toValue();
                interpreter.pushScope(oldValue);
                Item newItem = this.then.mapSelected(interpreter, transform);
                interpreter.popScope();
                if (newItem.isDefined()) {
                    if (newItem instanceof Field) {
                        scope = newItem;
                    } else if (newItem != oldValue) {
                        scope = ((Field)scope).updatedValue(newItem.toValue());
                    }
                } else {
                    scope = Item.absent();
                }
            } else {
                interpreter.pushScope(scope);
                scope = this.then.mapSelected(interpreter, transform);
                interpreter.popScope();
            }
            interpreter.pushScope(scope);
            result = scope;
        } else {
            result = Item.absent();
        }
        interpreter.didTransform(this, result);
        return result;
    }

    @Override
    public Item substitute(Interpreter interpreter) {
        Item then = this.then.substitute(interpreter);
        if (!(then instanceof Selector)) {
            then = this.then;
        }
        return new ValuesSelector((Selector)then);
    }

    @Override
    public Selector andThen(Selector then) {
        return new ValuesSelector(this.then.andThen(then));
    }

    @Override
    public int typeOrder() {
        return 16;
    }

    @Override
    protected int compareTo(Selector that) {
        if (that instanceof ValuesSelector) {
            return this.compareTo((ValuesSelector)that);
        }
        return Integer.compare(this.typeOrder(), that.typeOrder());
    }

    @Override
    int compareTo(ValuesSelector that) {
        return this.then.compareTo((Item)that.then);
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof ValuesSelector) {
            ValuesSelector that = (ValuesSelector)other;
            return this.then.equals(that.then);
        }
        return false;
    }

    @Override
    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(ValuesSelector.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)hashSeed, (int)this.then.hashCode()));
    }

    @Override
    public void debugThen(Output<?> output) {
        output = output.write(46).write("values").write(40).write(41);
        this.then.debugThen(output);
    }
}

