/*
 * Decompiled with CFR 0.152.
 */
package swim.structure;

import swim.codec.Output;
import swim.structure.Bool;
import swim.structure.Expression;
import swim.structure.Extant;
import swim.structure.Field;
import swim.structure.Interpreter;
import swim.structure.Item;
import swim.structure.Num;
import swim.structure.Slot;
import swim.structure.Text;
import swim.structure.Value;
import swim.structure.operator.BitwiseAndOperator;
import swim.structure.operator.BitwiseOrOperator;
import swim.structure.operator.BitwiseXorOperator;
import swim.structure.operator.DivideOperator;
import swim.structure.operator.MinusOperator;
import swim.structure.operator.ModuloOperator;
import swim.structure.operator.PlusOperator;
import swim.structure.operator.TimesOperator;

public final class Attr
extends Field {
    final Text key;
    Value value;

    Attr(Text key, Value value, int flags) {
        this.key = key;
        this.value = value;
        this.flags = flags;
    }

    Attr(Text key, Value value) {
        this(key, value, 0);
    }

    @Override
    public boolean isConstant() {
        return this.key.isConstant() && this.value.isConstant();
    }

    public String name() {
        return this.key.value;
    }

    @Override
    public Text key() {
        return this.key;
    }

    @Override
    public Value value() {
        return this.value;
    }

    @Override
    public Value setValue(Value newValue) {
        if ((this.flags & 1) != 0) {
            throw new UnsupportedOperationException("immutable");
        }
        Value oldValue = this.value;
        this.value = newValue;
        return oldValue;
    }

    @Override
    public Attr updatedValue(Value value) {
        if (value == null) {
            throw new NullPointerException();
        }
        return new Attr(this.key, value);
    }

    @Override
    public Item bitwiseOr(Item that) {
        if (that instanceof Expression) {
            return new BitwiseOrOperator(this, that);
        }
        Value newValue = that instanceof Attr && this.key.equals(((Attr)that).key) ? this.value.bitwiseOr(((Attr)that).value) : (that instanceof Value ? this.value.bitwiseOr((Value)that) : Value.absent());
        if (newValue.isDefined()) {
            return new Attr(this.key, newValue);
        }
        return Item.absent();
    }

    @Override
    public Item bitwiseXor(Item that) {
        if (that instanceof Expression) {
            return new BitwiseXorOperator(this, that);
        }
        Value newValue = that instanceof Attr && this.key.equals(((Attr)that).key) ? this.value.bitwiseXor(((Attr)that).value) : (that instanceof Value ? this.value.bitwiseXor((Value)that) : Value.absent());
        if (newValue.isDefined()) {
            return new Attr(this.key, newValue);
        }
        return Item.absent();
    }

    @Override
    public Item bitwiseAnd(Item that) {
        if (that instanceof Expression) {
            return new BitwiseAndOperator(this, that);
        }
        Value newValue = that instanceof Attr && this.key.equals(((Attr)that).key) ? this.value.bitwiseAnd(((Attr)that).value) : (that instanceof Value ? this.value.bitwiseAnd((Value)that) : Value.absent());
        if (newValue.isDefined()) {
            return new Attr(this.key, newValue);
        }
        return Item.absent();
    }

    @Override
    public Item plus(Item that) {
        if (that instanceof Expression) {
            return new PlusOperator(this, that);
        }
        Value newValue = that instanceof Attr && this.key.equals(((Attr)that).key) ? this.value.plus(((Attr)that).value) : (that instanceof Value ? this.value.plus((Value)that) : Value.absent());
        if (newValue.isDefined()) {
            return new Attr(this.key, newValue);
        }
        return Item.absent();
    }

    @Override
    public Item minus(Item that) {
        if (that instanceof Expression) {
            return new MinusOperator(this, that);
        }
        Value newValue = that instanceof Attr && this.key.equals(((Attr)that).key) ? this.value.minus(((Attr)that).value) : (that instanceof Value ? this.value.minus((Value)that) : Value.absent());
        if (newValue.isDefined()) {
            return new Attr(this.key, newValue);
        }
        return Item.absent();
    }

    @Override
    public Item times(Item that) {
        if (that instanceof Expression) {
            return new TimesOperator(this, that);
        }
        Value newValue = that instanceof Attr && this.key.equals(((Attr)that).key) ? this.value.times(((Attr)that).value) : (that instanceof Value ? this.value.times((Value)that) : Value.absent());
        if (newValue.isDefined()) {
            return new Attr(this.key, newValue);
        }
        return Item.absent();
    }

    @Override
    public Item divide(Item that) {
        if (that instanceof Expression) {
            return new DivideOperator(this, that);
        }
        Value newValue = that instanceof Attr && this.key.equals(((Attr)that).key) ? this.value.divide(((Attr)that).value) : (that instanceof Value ? this.value.divide((Value)that) : Value.absent());
        if (newValue.isDefined()) {
            return new Attr(this.key, newValue);
        }
        return Item.absent();
    }

    @Override
    public Item modulo(Item that) {
        if (that instanceof Expression) {
            return new ModuloOperator(this, that);
        }
        Value newValue = that instanceof Attr && this.key.equals(((Attr)that).key) ? this.value.modulo(((Attr)that).value) : (that instanceof Value ? this.value.modulo((Value)that) : Value.absent());
        if (newValue.isDefined()) {
            return new Attr(this.key, newValue);
        }
        return Item.absent();
    }

    @Override
    public Item not() {
        Value newValue = this.value.not();
        if (newValue.isDefined()) {
            return new Attr(this.key, newValue);
        }
        return Item.absent();
    }

    @Override
    public Item bitwiseNot() {
        Value newValue = this.value.bitwiseNot();
        if (newValue.isDefined()) {
            return new Attr(this.key, newValue);
        }
        return Item.absent();
    }

    @Override
    public Item negative() {
        Value newValue = this.value.negative();
        if (newValue.isDefined()) {
            return new Attr(this.key, newValue);
        }
        return Item.absent();
    }

    @Override
    public Item positive() {
        Value newValue = this.value.positive();
        if (newValue.isDefined()) {
            return new Attr(this.key, newValue);
        }
        return Item.absent();
    }

    @Override
    public Item inverse() {
        Value newValue = this.value.inverse();
        if (newValue.isDefined()) {
            return new Attr(this.key, newValue);
        }
        return Item.absent();
    }

    @Override
    public Item evaluate(Interpreter interpreter) {
        Value key = this.key.evaluate(interpreter).toValue();
        Value value = this.value.evaluate(interpreter).toValue();
        if (key == this.key && value == this.value) {
            return this;
        }
        if (key.isDefined() && value.isDefined()) {
            if (key instanceof Text) {
                return new Attr((Text)key, value);
            }
            return new Slot(key, value);
        }
        return Item.absent();
    }

    @Override
    public Item substitute(Interpreter interpreter) {
        Value key = this.key.substitute(interpreter).toValue();
        Value value = this.value.substitute(interpreter).toValue();
        if (key == this.key && value == this.value) {
            return this;
        }
        if (key.isDefined() && value.isDefined()) {
            if (key instanceof Text) {
                return new Attr((Text)key, value);
            }
            return new Slot(key, value);
        }
        return Item.absent();
    }

    @Override
    public boolean isAliased() {
        return false;
    }

    @Override
    public boolean isMutable() {
        return (this.flags & 1) == 0;
    }

    @Override
    public void alias() {
        int newFlags;
        int oldFlags;
        while (((oldFlags = this.flags) & 1) == 0 && !FLAGS.compareAndSet(this, oldFlags, newFlags = oldFlags | 1)) {
        }
    }

    @Override
    public Attr branch() {
        if ((this.flags & 1) != 0) {
            return new Attr(this.key, this.value, this.flags & 0xFFFFFFFE);
        }
        return this;
    }

    @Override
    public Attr commit() {
        int oldFlags;
        while (((oldFlags = this.flags) & 1) == 0) {
            int newFlags = oldFlags | 1;
            if (!FLAGS.compareAndSet(this, oldFlags, newFlags)) continue;
            this.value.commit();
            break;
        }
        return this;
    }

    @Override
    public int typeOrder() {
        return 1;
    }

    @Override
    public int compareTo(Item other) {
        if (other instanceof Attr) {
            return this.compareTo((Attr)other);
        }
        return Integer.compare(this.typeOrder(), other.typeOrder());
    }

    @Override
    int compareTo(Attr that) {
        int order = this.key.compareTo(that.key);
        if (order == 0) {
            order = this.value.compareTo(that.value);
        }
        return order;
    }

    @Override
    public boolean keyEquals(Object key) {
        if (key instanceof String) {
            return this.key.value.equals(key);
        }
        if (key instanceof Field) {
            return this.key.equals(((Field)key).getKey());
        }
        return this.key.equals(key);
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Attr) {
            Attr that = (Attr)other;
            return this.key.equals(that.key) && this.value.equals(that.value);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.key.hashCode() ^ this.value.hashCode();
    }

    @Override
    public void debug(Output<?> output) {
        output = output.write("Attr").write(46).write("of").write(40).display((Object)this.key);
        if (!(this.value instanceof Extant)) {
            output = output.write(", ").display((Object)this.value);
        }
        output = output.write(41);
    }

    public static Attr of(Text key, Value value) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        return new Attr(key, value);
    }

    public static Attr of(Text key, String value) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        return new Attr(key, Text.from(value));
    }

    public static Attr of(Text key, int value) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        return new Attr(key, Num.from(value));
    }

    public static Attr of(Text key, long value) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        return new Attr(key, Num.from(value));
    }

    public static Attr of(Text key, float value) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        return new Attr(key, Num.from(value));
    }

    public static Attr of(Text key, double value) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        return new Attr(key, Num.from(value));
    }

    public static Attr of(Text key, boolean value) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        return new Attr(key, Bool.from(value));
    }

    public static Attr of(String key, Value value) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        return new Attr(Text.from(key), value);
    }

    public static Attr of(String key, String value) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        return new Attr(Text.from(key), Text.from(value));
    }

    public static Attr of(String key, int value) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        return new Attr(Text.from(key), Num.from(value));
    }

    public static Attr of(String key, long value) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        return new Attr(Text.from(key), Num.from(value));
    }

    public static Attr of(String key, float value) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        return new Attr(Text.from(key), Num.from(value));
    }

    public static Attr of(String key, double value) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        return new Attr(Text.from(key), Num.from(value));
    }

    public static Attr of(String key, boolean value) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        return new Attr(Text.from(key), Bool.from(value));
    }

    public static Attr of(Text key) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        return new Attr(key, Value.extant());
    }

    public static Attr of(String key) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        return new Attr(Text.from(key), Value.extant());
    }
}

