/*
 * Decompiled with CFR 0.152.
 */
package swim.structure.operator;

import swim.codec.Output;
import swim.structure.Func;
import swim.structure.Interpreter;
import swim.structure.Item;
import swim.structure.Operator;
import swim.structure.Value;
import swim.util.Murmur3;

public final class InvokeOperator
extends Operator {
    final Value func;
    final Value args;
    Object state;
    private static int hashSeed;

    public InvokeOperator(Value func, Value args) {
        this.func = func;
        this.args = args;
    }

    public Value func() {
        return this.func;
    }

    public Value args() {
        return this.args;
    }

    public Object state() {
        return this.state;
    }

    public void setState(Object state) {
        this.state = state;
    }

    @Override
    public boolean isConstant() {
        return this.func.isConstant() && this.args.isConstant();
    }

    @Override
    public int precedence() {
        return 11;
    }

    @Override
    public Item evaluate(Interpreter interpreter) {
        interpreter.willOperate(this);
        Item func = this.func.evaluate(interpreter);
        Item result = func instanceof Func ? ((Func)func).invoke(this.args, interpreter, this) : Item.absent();
        interpreter.didOperate(this, result);
        return result;
    }

    @Override
    public Item substitute(Interpreter interpreter) {
        Item result;
        Item func = this.func.evaluate(interpreter);
        if (func instanceof Func && (result = ((Func)func).expand(this.args, interpreter, this)) != null) {
            return result;
        }
        Value args = this.args.substitute(interpreter).toValue();
        return new InvokeOperator(this.func, args);
    }

    @Override
    public int typeOrder() {
        return 41;
    }

    @Override
    protected int compareTo(Operator that) {
        if (that instanceof InvokeOperator) {
            return this.compareTo((InvokeOperator)that);
        }
        return Integer.compare(this.typeOrder(), that.typeOrder());
    }

    @Override
    int compareTo(InvokeOperator that) {
        int order = this.func.compareTo(that.func);
        if (order == 0) {
            order = this.args.compareTo(that.args);
        }
        return order;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof InvokeOperator) {
            InvokeOperator that = (InvokeOperator)other;
            return this.func.equals(that.func) && this.args.equals(that.args);
        }
        return false;
    }

    @Override
    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(InvokeOperator.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)this.func.hashCode()), (int)this.args.hashCode()));
    }

    @Override
    public void debug(Output<?> output) {
        output.debug((Object)this.func).write(46).write("invoke").write(40).debug((Object)this.args).write(41);
    }
}

