/*
 * Decompiled with CFR 0.152.
 */
package swim.structure.operator;

import swim.codec.Output;
import swim.structure.Interpreter;
import swim.structure.Item;
import swim.structure.Operator;
import swim.structure.operator.UnaryOperator;
import swim.util.Murmur3;

public final class NegativeOperator
extends UnaryOperator {
    private static int hashSeed;

    public NegativeOperator(Item operand) {
        super(operand);
    }

    @Override
    public String operator() {
        return "-";
    }

    @Override
    public int precedence() {
        return 10;
    }

    @Override
    public Item evaluate(Interpreter interpreter) {
        interpreter.willOperate(this);
        Item argument = this.operand.evaluate(interpreter);
        Item result = argument.negative();
        interpreter.didOperate(this, result);
        return result;
    }

    @Override
    public Item substitute(Interpreter interpreter) {
        Item argument = this.operand.substitute(interpreter);
        return argument.negative();
    }

    @Override
    public int typeOrder() {
        return 39;
    }

    @Override
    protected int compareTo(Operator that) {
        if (that instanceof NegativeOperator) {
            return this.compareTo((NegativeOperator)that);
        }
        return Integer.compare(this.typeOrder(), that.typeOrder());
    }

    @Override
    int compareTo(NegativeOperator that) {
        return this.operand.compareTo(that.operand);
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof NegativeOperator) {
            NegativeOperator that = (NegativeOperator)other;
            return this.operand.equals(that.operand);
        }
        return false;
    }

    @Override
    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(NegativeOperator.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)hashSeed, (int)this.operand.hashCode()));
    }

    @Override
    public void debug(Output<?> output) {
        output.debug((Object)this.operand).write(46).write("negative").write(40).write(41);
    }
}

