/*
 * Decompiled with CFR 0.152.
 */
package swim.structure;

import java.util.Iterator;
import swim.codec.Output;
import swim.structure.Attr;
import swim.structure.Item;
import swim.structure.ItemIterator;
import swim.structure.Record;
import swim.structure.Slot;
import swim.structure.Text;
import swim.structure.Value;
import swim.util.Murmur3;

public final class Absent
extends Value {
    private static int hashSeed;
    private static final Absent VALUE;

    private Absent() {
    }

    @Override
    public boolean isDefined() {
        return false;
    }

    @Override
    public boolean isDefinite() {
        return false;
    }

    @Override
    public boolean isConstant() {
        return true;
    }

    @Override
    public boolean isDistinct() {
        return false;
    }

    @Override
    public Record unflattened() {
        return Record.empty();
    }

    @Override
    public Record updated(Value key, Value value) {
        return Record.of((Object)Slot.of(key, value));
    }

    @Override
    public Record updatedAttr(Text key, Value value) {
        return Record.of((Object)Attr.of(key, value));
    }

    @Override
    public Record updatedSlot(Value key, Value value) {
        return Record.of((Object)Slot.of(key, value));
    }

    @Override
    public Record appended(Item item) {
        return Record.of((Object)item);
    }

    @Override
    public Record appended(Object ... items) {
        return Record.of(items);
    }

    @Override
    public Record prepended(Item item) {
        return Record.of((Object)item);
    }

    @Override
    public Record prepended(Object ... items) {
        return Record.of(items);
    }

    @Override
    public Record concat(Item that) {
        if (!that.isDefined()) {
            return Record.create();
        }
        if (that instanceof Record) {
            return ((Record)that).branch();
        }
        return Record.of((Object)that);
    }

    @Override
    public Item conditional(Item thenTerm, Item elseTerm) {
        return elseTerm;
    }

    @Override
    public Value conditional(Value thenTerm, Value elseTerm) {
        return elseTerm;
    }

    @Override
    public Item or(Item that) {
        return that;
    }

    @Override
    public Value or(Value that) {
        return that;
    }

    @Override
    public Item and(Item that) {
        return this;
    }

    @Override
    public Value and(Value that) {
        return this;
    }

    @Override
    public Value not() {
        return Value.extant();
    }

    @Override
    public boolean booleanValue() {
        return false;
    }

    @Override
    public boolean booleanValue(boolean orElse) {
        return false;
    }

    @Override
    public Iterator<Item> iterator() {
        return new ItemIterator(null);
    }

    @Override
    public int typeOrder() {
        return 99;
    }

    @Override
    public int compareTo(Item other) {
        return Integer.compare(this.typeOrder(), other.typeOrder());
    }

    @Override
    public boolean equals(Object other) {
        return this == other;
    }

    @Override
    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(Absent.class);
        }
        return hashSeed;
    }

    @Override
    public <T> Output<T> debug(Output<T> output) {
        output = output.write("Value").write(46).write("absent").write(40).write(41);
        return output;
    }

    public static Absent absent() {
        return VALUE;
    }

    static {
        VALUE = new Absent();
    }
}

