/*
 * Decompiled with CFR 0.152.
 */
package swim.structure.collections;

import java.util.Map;
import swim.structure.Form;
import swim.structure.Slot;
import swim.structure.Value;
import swim.structure.collections.ValueEntry;
import swim.util.Cursor;

public class ValueEntryCursor<K, V>
implements Cursor<Map.Entry<K, V>> {
    final Cursor<Map.Entry<Value, Value>> inner;
    final Form<K> keyForm;
    final Form<V> valueForm;

    public ValueEntryCursor(Cursor<? extends Map.Entry<? extends Value, ? extends Value>> inner, Form<K> keyForm, Form<V> valueForm) {
        this.inner = inner;
        this.keyForm = keyForm;
        this.valueForm = valueForm;
    }

    public Cursor<Map.Entry<Value, Value>> inner() {
        return this.inner;
    }

    public Form<K> keyForm() {
        return this.keyForm;
    }

    public <K2> ValueEntryCursor<K2, V> keyForm(Form<K2> keyForm) {
        return new ValueEntryCursor<K2, V>(this.inner, keyForm, this.valueForm);
    }

    public <K2> ValueEntryCursor<K2, V> keyClass(Class<K2> keyClass) {
        return this.keyForm(Form.forClass(keyClass));
    }

    public Form<V> valueForm() {
        return this.valueForm;
    }

    public <V2> ValueEntryCursor<K, V2> valueForm(Form<V2> valueForm) {
        return new ValueEntryCursor<K, V2>(this.inner, this.keyForm, valueForm);
    }

    public <V2> ValueEntryCursor<K, V2> valueClass(Class<V2> valueClass) {
        return this.valueForm(Form.forClass(valueClass));
    }

    public boolean isEmpty() {
        return this.inner.isEmpty();
    }

    public Map.Entry<K, V> head() {
        return new ValueEntry<K, V>((Map.Entry)this.inner.head(), this.keyForm, this.valueForm);
    }

    public void step() {
        this.inner.step();
    }

    public void skip(long count) {
        this.inner.skip(count);
    }

    public boolean hasNext() {
        return this.inner.hasNext();
    }

    public long nextIndexLong() {
        return this.inner.nextIndexLong();
    }

    public int nextIndex() {
        return this.inner.nextIndex();
    }

    public Map.Entry<K, V> next() {
        return new ValueEntry<K, V>((Map.Entry)this.inner.next(), this.keyForm, this.valueForm);
    }

    public boolean hasPrevious() {
        return this.inner.hasPrevious();
    }

    public long previousIndexLong() {
        return this.inner.previousIndexLong();
    }

    public int previousIndex() {
        return this.inner.previousIndex();
    }

    public Map.Entry<K, V> previous() {
        return new ValueEntry<K, V>((Map.Entry)this.inner.previous(), this.keyForm, this.valueForm);
    }

    public void set(Map.Entry<K, V> newEntry) {
        Value newKey = this.keyForm.mold(newEntry.getKey()).toValue();
        Value newValue = this.valueForm.mold(newEntry.getValue()).toValue();
        this.inner.set((Object)Slot.of(newKey, newValue));
    }

    public void add(Map.Entry<K, V> newEntry) {
        Value newKey = this.keyForm.mold(newEntry.getKey()).toValue();
        Value newValue = this.valueForm.mold(newEntry.getValue()).toValue();
        this.inner.add((Object)Slot.of(newKey, newValue));
    }

    public void remove() {
        this.inner.remove();
    }

    public void load() {
        this.inner.load();
    }
}

