/*
 * Decompiled with CFR 0.152.
 */
package swim.structure.operator;

import swim.codec.Output;
import swim.structure.Interpreter;
import swim.structure.Item;
import swim.structure.Operator;
import swim.structure.operator.BinaryOperator;
import swim.util.Murmur3;

public final class OrOperator
extends BinaryOperator {
    private static int hashSeed;

    public OrOperator(Item lhs, Item rhs) {
        super(lhs, rhs);
    }

    @Override
    public String operator() {
        return "||";
    }

    @Override
    public int precedence() {
        return 3;
    }

    @Override
    public Item evaluate(Interpreter interpreter) {
        Item rhs;
        interpreter.willOperate(this);
        Item lhs = this.lhs.evaluate(interpreter);
        Item result = lhs.isDefinite() ? lhs : (rhs = this.rhs.evaluate(interpreter));
        interpreter.didOperate(this, result);
        return result;
    }

    @Override
    public Item substitute(Interpreter interpreter) {
        Item lhs = this.lhs.substitute(interpreter);
        Item rhs = this.rhs.substitute(interpreter);
        return lhs.or(rhs);
    }

    @Override
    public int typeOrder() {
        return 21;
    }

    @Override
    protected int compareTo(Operator that) {
        if (that instanceof OrOperator) {
            return this.compareTo((OrOperator)that);
        }
        return Integer.compare(this.typeOrder(), that.typeOrder());
    }

    @Override
    int compareTo(OrOperator that) {
        int order = this.lhs.compareTo(that.lhs);
        if (order == 0) {
            order = this.rhs.compareTo(that.rhs);
        }
        return order;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof OrOperator) {
            OrOperator that = (OrOperator)other;
            return this.lhs.equals(that.lhs) && this.rhs.equals(that.rhs);
        }
        return false;
    }

    @Override
    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(OrOperator.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)this.lhs.hashCode()), (int)this.rhs.hashCode()));
    }

    @Override
    public <T> Output<T> debug(Output<T> output) {
        output = output.debug((Object)this.lhs).write(46).write("or").write(40).debug((Object)this.rhs).write(41);
        return output;
    }
}

