/*
 * Decompiled with CFR 0.152.
 */
package swim.structure.selector;

import swim.codec.Output;
import swim.structure.Attr;
import swim.structure.Field;
import swim.structure.Interpreter;
import swim.structure.Item;
import swim.structure.Record;
import swim.structure.Selectee;
import swim.structure.Selector;
import swim.structure.Text;
import swim.structure.Value;
import swim.util.Murmur3;

public final class GetAttrSelector
extends Selector {
    final Text key;
    final Selector then;
    private static int hashSeed;

    public GetAttrSelector(Text key, Selector then) {
        this.key = key;
        this.then = then;
    }

    public Text accessor() {
        return this.key;
    }

    @Override
    public Selector then() {
        return this.then;
    }

    @Override
    public <T> T forSelected(Interpreter interpreter, Selectee<T> callback) {
        interpreter.willSelect(this);
        Text key = this.key;
        T selected = GetAttrSelector.forSelected(key, this.then, interpreter, callback);
        interpreter.didSelect(this, selected);
        return selected;
    }

    private static <T> T forSelected(Value key, Selector then, Interpreter interpreter, Selectee<T> callback) {
        T selected = null;
        if (interpreter.scopeDepth() != 0) {
            Field field;
            Value scope = interpreter.popScope().toValue();
            if (scope instanceof Record) {
                field = scope.getField(key);
                if (field instanceof Attr) {
                    interpreter.pushScope(field.toValue());
                    selected = then.forSelected(interpreter, callback);
                    interpreter.popScope();
                }
            } else {
                field = null;
            }
            if (field == null && selected == null) {
                GetAttrSelector.forSelected(key, then, interpreter, callback);
            }
            interpreter.pushScope(scope);
        }
        return selected;
    }

    @Override
    public Item mapSelected(Interpreter interpreter, Selectee<Item> transform) {
        Item result;
        interpreter.willTransform(this);
        Text key = this.key;
        if (interpreter.scopeDepth() != 0) {
            Record record;
            Field oldField;
            Value scope = interpreter.popScope().toValue();
            if (scope instanceof Record && (oldField = (record = (Record)scope).getField(key)) instanceof Attr) {
                interpreter.pushScope(oldField.toValue());
                Item newItem = this.then.mapSelected(interpreter, transform);
                interpreter.popScope();
                if (newItem instanceof Field) {
                    if (key.equals(newItem.key())) {
                        record.putAttr(key, newItem.toValue());
                    } else {
                        record.remove(key);
                        record.add(newItem);
                    }
                } else if (newItem.isDefined()) {
                    record.putAttr(key, newItem.toValue());
                } else {
                    record.remove(key);
                }
            }
            interpreter.pushScope(scope);
            result = scope;
        } else {
            result = Item.absent();
        }
        interpreter.didTransform(this, result);
        return result;
    }

    @Override
    public Item substitute(Interpreter interpreter) {
        Text key = this.key;
        Item value = GetAttrSelector.substitute(key, this.then, interpreter);
        if (value != null) {
            return value;
        }
        Item then = this.then.substitute(interpreter);
        if (!(then instanceof Selector)) {
            then = this.then;
        }
        return new GetAttrSelector(this.key, (Selector)then);
    }

    private static Item substitute(Text key, Selector then, Interpreter interpreter) {
        Item selected = null;
        if (interpreter.scopeDepth() != 0) {
            Field field;
            Value scope = interpreter.popScope().toValue();
            if (scope instanceof Record) {
                field = scope.getField(key);
                if (field instanceof Attr) {
                    selected = field.toValue().substitute(interpreter);
                }
            } else {
                field = null;
            }
            if (field != null && selected != null) {
                GetAttrSelector.substitute(key, then, interpreter);
            }
            interpreter.pushScope(scope);
        }
        return selected;
    }

    @Override
    public Selector andThen(Selector then) {
        return new GetAttrSelector(this.key, this.then.andThen(then));
    }

    @Override
    public int typeOrder() {
        return 13;
    }

    @Override
    protected int compareTo(Selector that) {
        if (that instanceof GetAttrSelector) {
            return this.compareTo((GetAttrSelector)that);
        }
        return Integer.compare(this.typeOrder(), that.typeOrder());
    }

    @Override
    int compareTo(GetAttrSelector that) {
        int order = this.key.compareTo(that.key);
        if (order == 0) {
            order = this.then.compareTo((Item)that.then);
        }
        return order;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof GetAttrSelector) {
            GetAttrSelector that = (GetAttrSelector)other;
            return this.key.equals(that.key) && this.then.equals(that.then);
        }
        return false;
    }

    @Override
    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(GetAttrSelector.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)this.key.hashCode()), (int)this.then.hashCode()));
    }

    @Override
    public <T> Output<T> debugThen(Output<T> output) {
        output = output.write(46).write("getAttr").write(40).debug((Object)this.key).write(41);
        output = this.then.debugThen(output);
        return output;
    }
}

