/*
 * Decompiled with CFR 0.152.
 */
package swim.structure;

import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import swim.codec.Base16;
import swim.codec.Base64;
import swim.codec.Binary;
import swim.codec.Input;
import swim.codec.InputBuffer;
import swim.codec.Output;
import swim.codec.OutputSettings;
import swim.codec.Unicode;
import swim.codec.Utf8;
import swim.codec.Writer;
import swim.structure.DataOutput;
import swim.structure.Item;
import swim.structure.Value;
import swim.util.Murmur3;

public class Data
extends Value {
    byte[] array;
    int offset;
    int size;
    volatile int flags;
    private static int hashSeed;
    static final int ALIASED = 1;
    static final int IMMUTABLE = 2;
    static final AtomicIntegerFieldUpdater<Data> FLAGS;
    private static Data empty;

    Data(byte[] array, int offset, int size, int flags) {
        this.array = array;
        this.offset = offset;
        this.size = size;
        this.flags = flags;
    }

    protected Data(byte[] array, int offset, int size) {
        this.array = array;
        this.offset = offset;
        this.size = size;
        this.flags = 0;
    }

    public Data(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException(Integer.toString(initialCapacity));
        }
        this.array = new byte[initialCapacity];
        this.offset = 0;
        this.size = 0;
        this.flags = 0;
    }

    public Data() {
        this.array = null;
        this.offset = 0;
        this.size = 0;
        this.flags = 1;
    }

    @Override
    public boolean isConstant() {
        return true;
    }

    public final int size() {
        return this.size;
    }

    public byte getByte(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException(Integer.toString(index));
        }
        return this.array[this.offset + index];
    }

    public Data setByte(int index, byte value) {
        int flags = FLAGS.get(this);
        if ((flags & 2) != 0) {
            throw new UnsupportedOperationException("immutable");
        }
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException(Integer.toString(index));
        }
        if ((flags & 1) != 0) {
            return this.setByteAliased(index, value);
        }
        return this.setByteMutable(index, value);
    }

    private Data setByteAliased(int index, byte value) {
        int newFlags;
        int oldFlags;
        int n = this.size;
        byte[] oldArray = this.array;
        byte[] newArray = new byte[Data.expand(n)];
        System.arraycopy(oldArray, this.offset, newArray, 0, n);
        newArray[index] = value;
        this.array = newArray;
        this.offset = 0;
        while (!FLAGS.compareAndSet(this, oldFlags = FLAGS.get(this), newFlags = oldFlags & 0xFFFFFFFE)) {
        }
        return this;
    }

    private Data setByteMutable(int index, byte value) {
        this.array[this.offset + index] = value;
        return this;
    }

    public Data addByte(byte value) {
        int flags = FLAGS.get(this);
        if ((flags & 2) != 0) {
            throw new UnsupportedOperationException("immutable");
        }
        if ((flags & 1) != 0) {
            return this.addByteAliased(value);
        }
        return this.addByteMutable(value);
    }

    private Data addByteAliased(byte value) {
        int newFlags;
        int oldFlags;
        int n = this.size;
        byte[] oldArray = this.array;
        byte[] newArray = new byte[Data.expand(n + 1)];
        if (oldArray != null) {
            System.arraycopy(oldArray, this.offset, newArray, 0, n);
        }
        newArray[n] = value;
        this.array = newArray;
        this.offset = 0;
        this.size = n + 1;
        while (!FLAGS.compareAndSet(this, oldFlags = FLAGS.get(this), newFlags = oldFlags & 0xFFFFFFFE)) {
        }
        return this;
    }

    private Data addByteMutable(byte value) {
        byte[] newArray;
        int n = this.size;
        byte[] oldArray = this.array;
        if (oldArray == null || n + 1 > oldArray.length) {
            newArray = new byte[Data.expand(n + 1)];
            if (oldArray != null) {
                System.arraycopy(oldArray, this.offset, newArray, 0, n);
            }
            this.array = newArray;
            this.offset = 0;
        } else {
            newArray = oldArray;
        }
        newArray[this.offset + n] = value;
        this.size = n + 1;
        return this;
    }

    public Data addByteArray(byte[] array, int offset, int size) {
        int flags = FLAGS.get(this);
        if ((flags & 2) != 0) {
            throw new UnsupportedOperationException("immutable");
        }
        if ((flags & 1) != 0) {
            return this.addByteArrayAliased(array, offset, size);
        }
        return this.addByteArrayMutable(array, offset, size);
    }

    public Data addByteArray(byte[] array) {
        return this.addByteArray(array, 0, array.length);
    }

    private Data addByteArrayAliased(byte[] array, int offset, int size) {
        int newFlags;
        int oldFlags;
        if (size == 0) {
            return this;
        }
        int n = this.size;
        byte[] oldArray = this.array;
        byte[] newArray = new byte[Data.expand(n + size)];
        if (oldArray != null) {
            System.arraycopy(oldArray, this.offset, newArray, 0, n);
        }
        System.arraycopy(array, offset, newArray, n, size);
        this.array = newArray;
        this.offset = 0;
        this.size = n + size;
        while (!FLAGS.compareAndSet(this, oldFlags = FLAGS.get(this), newFlags = oldFlags & 0xFFFFFFFE)) {
        }
        return this;
    }

    private Data addByteArrayMutable(byte[] array, int offset, int size) {
        byte[] newArray;
        if (size == 0) {
            return this;
        }
        int n = this.size;
        byte[] oldArray = this.array;
        if (oldArray == null || n + size > oldArray.length) {
            newArray = new byte[Data.expand(n + size)];
            if (oldArray != null) {
                System.arraycopy(oldArray, this.offset, newArray, 0, n);
            }
            this.array = newArray;
            this.offset = 0;
        } else {
            newArray = oldArray;
        }
        System.arraycopy(array, offset, newArray, this.offset + n, size);
        this.size = n + size;
        return this;
    }

    public Data addData(Data data) {
        return this.addByteArray(data.array, data.offset, data.size);
    }

    public void clear() {
        if ((FLAGS.get(this) & 2) != 0) {
            throw new UnsupportedOperationException("immutable");
        }
        this.array = null;
        this.offset = 0;
        this.size = 0;
        FLAGS.set(this, 1);
    }

    public byte[] toByteArray() {
        int n = this.size;
        byte[] oldArray = this.array;
        int flags = FLAGS.get(this);
        if ((flags & 2) != 0) {
            byte[] newArray = new byte[n];
            if (oldArray != null) {
                System.arraycopy(oldArray, this.offset, newArray, 0, n);
            }
            return newArray;
        }
        if ((flags & 1) != 0 || n != oldArray.length) {
            int newFlags;
            int oldFlags;
            byte[] newArray = new byte[n];
            if (oldArray != null) {
                System.arraycopy(oldArray, this.offset, newArray, 0, n);
            }
            this.array = newArray;
            this.offset = 0;
            while (!FLAGS.compareAndSet(this, oldFlags = FLAGS.get(this), newFlags = oldFlags & 0xFFFFFFFE)) {
            }
            return newArray;
        }
        return oldArray;
    }

    public byte[] asByteArray() {
        return this.array;
    }

    public ByteBuffer toByteBuffer() {
        int newFlags;
        int oldFlags;
        int flags = FLAGS.get(this);
        if ((flags & 1) != 0) {
            int n = this.size;
            byte[] oldArray = this.array;
            byte[] newArray = new byte[n];
            if (oldArray != null) {
                System.arraycopy(oldArray, this.offset, newArray, 0, n);
            }
            return ByteBuffer.wrap(newArray);
        }
        ByteBuffer buffer = ByteBuffer.wrap(this.array, this.offset, this.size);
        if ((flags & 2) != 0) {
            buffer = buffer.asReadOnlyBuffer();
        }
        while (!FLAGS.compareAndSet(this, oldFlags = FLAGS.get(this), newFlags = oldFlags | 1)) {
        }
        return buffer;
    }

    public ByteBuffer asByteBuffer() {
        if (this.array != null && this.size > 0) {
            return ByteBuffer.wrap(this.array, this.offset, this.size);
        }
        return null;
    }

    public InputBuffer toInputBuffer() {
        return Binary.inputBuffer((byte[])this.toByteArray());
    }

    @Override
    public boolean isAliased() {
        return (FLAGS.get(this) & 1) != 0;
    }

    @Override
    public boolean isMutable() {
        return (FLAGS.get(this) & 2) == 0;
    }

    @Override
    public Data branch() {
        int newFlags;
        int oldFlags;
        while (((oldFlags = FLAGS.get(this)) & 1) == 0 && !FLAGS.compareAndSet(this, oldFlags, newFlags = oldFlags | 1)) {
        }
        return new Data(this.array, this.offset, this.size, 1);
    }

    @Override
    public Data commit() {
        int newFlags;
        int oldFlags;
        while (((oldFlags = FLAGS.get(this)) & 2) == 0 && !FLAGS.compareAndSet(this, oldFlags, newFlags = oldFlags | 2)) {
        }
        return this;
    }

    public Writer<?, ?> writer() {
        if (this.array != null && this.size > 0) {
            int newFlags;
            int oldFlags;
            ByteBuffer buffer = ByteBuffer.wrap(this.array, 0, this.size);
            while (((oldFlags = FLAGS.get(this)) & 1) == 0 && !FLAGS.compareAndSet(this, oldFlags, newFlags = oldFlags | 1)) {
            }
            return Binary.byteBufferWriter((ByteBuffer)buffer);
        }
        return Writer.done();
    }

    public Writer<?, ?> write(Output<?> output) {
        if (this.array != null && this.size > 0) {
            int newFlags;
            int oldFlags;
            ByteBuffer buffer = ByteBuffer.wrap(this.array, 0, this.size);
            while (((oldFlags = FLAGS.get(this)) & 1) == 0 && !FLAGS.compareAndSet(this, oldFlags, newFlags = oldFlags | 1)) {
            }
            return Binary.writeByteBuffer(output, (ByteBuffer)buffer);
        }
        return Writer.done();
    }

    public Writer<?, ?> writeBase16(Output<?> output, Base16 base16) {
        if (this.array != null && this.size != 0) {
            return base16.writeByteBuffer(output, ByteBuffer.wrap(this.array, this.offset, this.size));
        }
        return Writer.done();
    }

    public Writer<?, ?> writeBase16(Output<?> output) {
        return this.writeBase16(output, Base16.uppercase());
    }

    public String toBase16(Base16 base16) {
        Output output = Unicode.stringOutput();
        this.writeBase16(output, base16).bind();
        return (String)output.bind();
    }

    public String toBase16() {
        return this.toBase16(Base16.uppercase());
    }

    public Writer<?, ?> writeBase64(Output<?> output, Base64 base64) {
        if (this.array != null && this.size != 0) {
            return base64.writeByteBuffer(output, ByteBuffer.wrap(this.array, this.offset, this.size));
        }
        return Writer.done();
    }

    public Writer<?, ?> writeBase64(Output<?> output) {
        return this.writeBase64(output, Base64.standard());
    }

    public String toBase64(Base64 base64) {
        Output output = Unicode.stringOutput();
        this.writeBase64(output, base64).bind();
        return (String)output.bind();
    }

    public String toBase64() {
        return this.toBase64(Base64.standard());
    }

    @Override
    public int typeOrder() {
        return 4;
    }

    @Override
    public int compareTo(Item other) {
        if (other instanceof Data) {
            return this.compareTo((Data)other);
        }
        return Integer.compare(this.typeOrder(), other.typeOrder());
    }

    @Override
    int compareTo(Data that) {
        int yi;
        byte[] xs = this.array;
        byte[] ys = that.array;
        int xi = this.offset;
        int xn = this.size;
        int yn = that.size;
        int xu = xi + xn;
        int ju = yi + yn;
        int order = 0;
        for (yi = that.offset; xi < xu && yi < ju; ++xi, ++yi) {
            order = xs[xi] - ys[yi];
            if (order == 0) continue;
        }
        if (order > 0) {
            return 1;
        }
        if (order < 0) {
            return -1;
        }
        if (xn > yn) {
            return 1;
        }
        if (xn < yn) {
            return -1;
        }
        return 0;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Data) {
            Data that = (Data)other;
            byte[] xs = this.array;
            byte[] ys = that.array;
            int xi = this.offset;
            int yi = that.offset;
            int xn = this.size;
            if (xn != that.size) {
                return false;
            }
            int xu = xi + xn;
            while (xi < xu) {
                if (xs[xi] != ys[yi]) {
                    return false;
                }
                ++xi;
                ++yi;
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(Data.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)hashSeed, (byte[])this.array, (int)this.offset, (int)this.size));
    }

    @Override
    public <T> Output<T> debug(Output<T> output) {
        output = output.write("Data").write(46);
        if (this.size == 0) {
            output = output.write("empty").write(40).write(41);
        } else {
            Writer<?, ?> writer = this.writeBase16(output = output.write("fromBase16").write(40).write(34));
            if (!writer.isDone()) {
                return Output.error((Throwable)writer.trap());
            }
            output = output.write(34).write(41);
        }
        return output;
    }

    public static Data empty() {
        if (empty == null) {
            empty = new Data(null, 0, 0, 3);
        }
        return empty;
    }

    public static Data create() {
        return new Data(null, 0, 0, 1);
    }

    public static Data create(int initialCapacity) {
        return new Data(new byte[initialCapacity], 0, 0, 0);
    }

    public static Data wrap(ByteBuffer buffer) {
        if (!buffer.hasArray()) {
            throw new IllegalArgumentException();
        }
        return new Data(buffer.array(), buffer.arrayOffset(), buffer.remaining(), 1);
    }

    public static Data wrap(byte[] array, int offset, int size) {
        return new Data(array, offset, size, 1);
    }

    public static Data wrap(byte[] array) {
        return new Data(array, 0, array.length, 1);
    }

    public static Data from(ByteBuffer buffer) {
        int n = buffer.remaining();
        if (buffer.hasArray()) {
            byte[] array = buffer.array();
            return new Data(array, buffer.arrayOffset(), buffer.remaining(), 1);
        }
        byte[] array = new byte[n];
        buffer.get(array);
        return new Data(array, 0, n, 0);
    }

    public static Data fromBase16(String string) {
        return (Data)Base16.parse((Input)Unicode.stringInput((String)string), Data.output()).bind();
    }

    public static Data fromBase64(String string, Base64 base64) {
        return (Data)base64.parse(Unicode.stringInput((String)string), Data.output()).bind();
    }

    public static Data fromBase64(String string) {
        return Data.fromBase64(string, Base64.standard());
    }

    public static Data fromUtf8(String string) {
        Output output = Utf8.encodedOutput(Data.output());
        int i = 0;
        int n = string.length();
        while (i < n) {
            output = output.write(string.codePointAt(i));
            i = string.offsetByCodePoints(i, 1);
        }
        return (Data)output.bind();
    }

    public static Output<Data> output(Data data) {
        return new DataOutput(data, OutputSettings.standard());
    }

    public static Output<Data> output(int initialCapacity) {
        return new DataOutput(new Data(initialCapacity), OutputSettings.standard());
    }

    public static Output<Data> output() {
        return new DataOutput(new Data(), OutputSettings.standard());
    }

    static int expand(int n) {
        n = Math.max(32, n) - 1;
        n |= n >> 1;
        n |= n >> 2;
        n |= n >> 4;
        n |= n >> 8;
        n |= n >> 16;
        return n + 1;
    }

    static {
        FLAGS = AtomicIntegerFieldUpdater.newUpdater(Data.class, "flags");
    }
}

