/*
 * Decompiled with CFR 0.152.
 */
package swim.structure;

import swim.codec.Output;
import swim.structure.Expression;
import swim.structure.Interpreter;
import swim.structure.Item;
import swim.structure.Num;
import swim.structure.Operator;
import swim.structure.Record;
import swim.structure.Selectee;
import swim.structure.SelecteeBuilder;
import swim.structure.Text;
import swim.structure.Value;
import swim.structure.operator.InvokeOperator;
import swim.structure.selector.FilterSelector;
import swim.structure.selector.GetAttrSelector;
import swim.structure.selector.GetItemSelector;
import swim.structure.selector.GetSelector;
import swim.structure.selector.IdentitySelector;
import swim.structure.selector.LiteralSelector;

public abstract class Selector
extends Expression {
    @Override
    public boolean isConstant() {
        return false;
    }

    public abstract Selector then();

    public abstract <T> T forSelected(Interpreter var1, Selectee<T> var2);

    public abstract Item mapSelected(Interpreter var1, Selectee<Item> var2);

    @Override
    public final Item evaluate(Interpreter interpreter) {
        Record selected = Record.create();
        SelecteeBuilder callback = new SelecteeBuilder(selected);
        this.forSelected(interpreter, callback);
        return selected.isEmpty() ? Item.absent() : selected.flattened();
    }

    public abstract Selector andThen(Selector var1);

    @Override
    public Selector get(Value key) {
        return this.andThen(new GetSelector(key, Selector.identity()));
    }

    @Override
    public Selector get(String key) {
        return this.get(Text.from(key));
    }

    @Override
    public Selector getAttr(Text key) {
        return this.andThen(new GetAttrSelector(key, Selector.identity()));
    }

    @Override
    public Selector getAttr(String key) {
        return this.getAttr(Text.from(key));
    }

    public Selector getItem(Num index) {
        return this.andThen(new GetItemSelector(index, Selector.identity()));
    }

    @Override
    public Selector getItem(int index) {
        return this.getItem(Num.from(index));
    }

    public Selector keys() {
        return this.andThen(Selector.identity().keys());
    }

    public Selector values() {
        return this.andThen(Selector.identity().values());
    }

    public Selector children() {
        return this.andThen(Selector.identity().children());
    }

    public Selector descendants() {
        return this.andThen(Selector.identity().descendants());
    }

    @Override
    public FilterSelector filter() {
        return new FilterSelector(this, Selector.identity());
    }

    @Override
    public Selector filter(Item predicate) {
        return this.andThen(predicate.filter());
    }

    @Override
    public Operator invoke(Value args) {
        return new InvokeOperator(this, args);
    }

    @Override
    public int precedence() {
        return 11;
    }

    @Override
    public <T> Output<T> debug(Output<T> output) {
        output = output.write("Selector").write(46).write("identity").write(40).write(41);
        output = this.debugThen(output);
        return output;
    }

    public abstract <T> Output<T> debugThen(Output<T> var1);

    @Override
    public int compareTo(Item other) {
        if (other instanceof Selector) {
            return this.compareTo((Selector)other);
        }
        return Integer.compare(this.typeOrder(), other.typeOrder());
    }

    @Override
    protected abstract int compareTo(Selector var1);

    public static Selector identity() {
        return IdentitySelector.identity();
    }

    public static Selector literal(Item item) {
        if (item instanceof Selector) {
            return (Selector)item;
        }
        return new LiteralSelector(item, Selector.identity());
    }
}

