/*
 * Decompiled with CFR 0.152.
 */
package swim.structure;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import swim.structure.Absent;
import swim.structure.Attr;
import swim.structure.Bool;
import swim.structure.Data;
import swim.structure.Expression;
import swim.structure.Extant;
import swim.structure.Field;
import swim.structure.Item;
import swim.structure.Num;
import swim.structure.Record;
import swim.structure.Slot;
import swim.structure.Text;
import swim.structure.ValueBuilder;
import swim.structure.func.LambdaFunc;
import swim.structure.operator.BitwiseAndOperator;
import swim.structure.operator.BitwiseOrOperator;
import swim.structure.operator.BitwiseXorOperator;
import swim.structure.operator.DivideOperator;
import swim.structure.operator.EqOperator;
import swim.structure.operator.GeOperator;
import swim.structure.operator.GtOperator;
import swim.structure.operator.LeOperator;
import swim.structure.operator.LtOperator;
import swim.structure.operator.MinusOperator;
import swim.structure.operator.ModuloOperator;
import swim.structure.operator.NeOperator;
import swim.structure.operator.PlusOperator;
import swim.structure.operator.TimesOperator;
import swim.util.Builder;

public abstract class Value
extends Item {
    Value() {
    }

    @Override
    public boolean isDefined() {
        return true;
    }

    @Override
    public boolean isDistinct() {
        return true;
    }

    @Override
    public boolean isDefinite() {
        return true;
    }

    @Override
    public final Value key() {
        return Value.absent();
    }

    @Override
    public final Value toValue() {
        return this;
    }

    @Override
    public String tag() {
        return null;
    }

    @Override
    public Value target() {
        return this;
    }

    @Override
    public Value flattened() {
        return this;
    }

    @Override
    public Record unflattened() {
        return Record.of((Object)this);
    }

    @Override
    public Value header(String tag) {
        return Value.absent();
    }

    @Override
    public Record headers(String tag) {
        return null;
    }

    @Override
    public Item head() {
        return Item.absent();
    }

    @Override
    public Record tail() {
        return Record.empty();
    }

    @Override
    public Value body() {
        return Value.extant();
    }

    @Override
    public int length() {
        return 0;
    }

    @Override
    public boolean contains(Item item) {
        return false;
    }

    @Override
    public boolean containsKey(Value key) {
        return false;
    }

    @Override
    public boolean containsKey(String key) {
        return false;
    }

    @Override
    public boolean containsValue(Value value) {
        return false;
    }

    @Override
    public Value get(Value key) {
        return Value.absent();
    }

    @Override
    public Value get(String key) {
        return Value.absent();
    }

    @Override
    public Value getAttr(Text key) {
        return Value.absent();
    }

    @Override
    public Value getAttr(String key) {
        return Value.absent();
    }

    @Override
    public Value getSlot(Value key) {
        return Value.absent();
    }

    @Override
    public Value getSlot(String key) {
        return Value.absent();
    }

    @Override
    public Field getField(Value key) {
        return null;
    }

    @Override
    public Field getField(String key) {
        return null;
    }

    @Override
    public Item getItem(int index) {
        return Item.absent();
    }

    @Override
    public Value removed(Value key) {
        return this;
    }

    @Override
    public Value removed(String key) {
        return this;
    }

    @Override
    public Item conditional(Item thenTerm, Item elseTerm) {
        if (thenTerm instanceof Value && elseTerm instanceof Value) {
            return this.conditional((Value)thenTerm, (Value)elseTerm);
        }
        return thenTerm;
    }

    public Value conditional(Value thenTerm, Value elseTerm) {
        return thenTerm;
    }

    @Override
    public Item or(Item that) {
        if (that instanceof Value) {
            return this.or((Value)that);
        }
        return this;
    }

    public Value or(Value that) {
        return this;
    }

    @Override
    public Item and(Item that) {
        if (that instanceof Value) {
            return this.and((Value)that);
        }
        return that;
    }

    public Value and(Value that) {
        return that;
    }

    @Override
    public Item bitwiseOr(Item that) {
        Value newValue;
        if (that instanceof Value) {
            return this.bitwiseOr((Value)that);
        }
        if (that instanceof Slot) {
            Value newValue2 = this.bitwiseOr(((Slot)that).value);
            if (newValue2.isDefined()) {
                return new Slot(((Slot)that).key, newValue2);
            }
        } else if (that instanceof Attr && (newValue = this.bitwiseOr(((Attr)that).value)).isDefined()) {
            return new Attr(((Attr)that).key, newValue);
        }
        return Item.absent();
    }

    public Value bitwiseOr(Value that) {
        if (that instanceof Expression) {
            return new BitwiseOrOperator(this, that);
        }
        return Value.absent();
    }

    @Override
    public Item bitwiseXor(Item that) {
        Value newValue;
        if (that instanceof Value) {
            return this.bitwiseXor((Value)that);
        }
        if (that instanceof Slot) {
            Value newValue2 = this.bitwiseXor(((Slot)that).value);
            if (newValue2.isDefined()) {
                return new Slot(((Slot)that).key, newValue2);
            }
        } else if (that instanceof Attr && (newValue = this.bitwiseXor(((Attr)that).value)).isDefined()) {
            return new Attr(((Attr)that).key, newValue);
        }
        return Item.absent();
    }

    public Value bitwiseXor(Value that) {
        if (that instanceof Expression) {
            return new BitwiseXorOperator(this, that);
        }
        return Value.absent();
    }

    @Override
    public Item bitwiseAnd(Item that) {
        Value newValue;
        if (that instanceof Value) {
            return this.bitwiseAnd((Value)that);
        }
        if (that instanceof Slot) {
            Value newValue2 = this.bitwiseAnd(((Slot)that).value);
            if (newValue2.isDefined()) {
                return new Slot(((Slot)that).key, newValue2);
            }
        } else if (that instanceof Attr && (newValue = this.bitwiseAnd(((Attr)that).value)).isDefined()) {
            return new Attr(((Attr)that).key, newValue);
        }
        return Item.absent();
    }

    public Value bitwiseAnd(Value that) {
        if (that instanceof Expression) {
            return new BitwiseAndOperator(this, that);
        }
        return Value.absent();
    }

    @Override
    public Item lt(Item that) {
        if (that instanceof Value) {
            return this.lt((Value)that);
        }
        return super.lt(that);
    }

    public Value lt(Value that) {
        if (that instanceof Expression) {
            return new LtOperator(this, that);
        }
        return (Value)super.lt(that);
    }

    @Override
    public Item le(Item that) {
        if (that instanceof Value) {
            return this.le((Value)that);
        }
        return super.le(that);
    }

    public Value le(Value that) {
        if (that instanceof Expression) {
            return new LeOperator(this, that);
        }
        return (Value)super.le(that);
    }

    @Override
    public Item eq(Item that) {
        if (that instanceof Value) {
            return this.eq((Value)that);
        }
        return super.eq(that);
    }

    public Value eq(Value that) {
        if (that instanceof Expression) {
            return new EqOperator(this, that);
        }
        return (Value)super.eq(that);
    }

    @Override
    public Item ne(Item that) {
        if (that instanceof Value) {
            return this.ne((Value)that);
        }
        return super.ne(that);
    }

    public Value ne(Value that) {
        if (that instanceof Expression) {
            return new NeOperator(this, that);
        }
        return (Value)super.ne(that);
    }

    @Override
    public Item ge(Item that) {
        if (that instanceof Value) {
            return this.ge((Value)that);
        }
        return super.ge(that);
    }

    public Value ge(Value that) {
        if (that instanceof Expression) {
            return new GeOperator(this, that);
        }
        return (Value)super.ge(that);
    }

    @Override
    public Item gt(Item that) {
        if (that instanceof Value) {
            return this.gt((Value)that);
        }
        return super.gt(that);
    }

    public Value gt(Value that) {
        if (that instanceof Expression) {
            return new GtOperator(this, that);
        }
        return (Value)super.gt(that);
    }

    @Override
    public Item plus(Item that) {
        Value newValue;
        if (that instanceof Value) {
            return this.plus((Value)that);
        }
        if (that instanceof Slot) {
            Value newValue2 = this.plus(((Slot)that).value);
            if (newValue2.isDefined()) {
                return new Slot(((Slot)that).key, newValue2);
            }
        } else if (that instanceof Attr && (newValue = this.plus(((Attr)that).value)).isDefined()) {
            return new Attr(((Attr)that).key, newValue);
        }
        return Item.absent();
    }

    public Value plus(Value that) {
        if (that instanceof Expression) {
            return new PlusOperator(this, that);
        }
        return Value.absent();
    }

    @Override
    public Item minus(Item that) {
        Value newValue;
        if (that instanceof Value) {
            return this.minus((Value)that);
        }
        if (that instanceof Slot) {
            Value newValue2 = this.minus(((Slot)that).value);
            if (newValue2.isDefined()) {
                return new Slot(((Slot)that).key, newValue2);
            }
        } else if (that instanceof Attr && (newValue = this.minus(((Attr)that).value)).isDefined()) {
            return new Attr(((Attr)that).key, newValue);
        }
        return Item.absent();
    }

    public Value minus(Value that) {
        if (that instanceof Expression) {
            return new MinusOperator(this, that);
        }
        return Value.absent();
    }

    @Override
    public Item times(Item that) {
        Value newValue;
        if (that instanceof Value) {
            return this.times((Value)that);
        }
        if (that instanceof Slot) {
            Value newValue2 = this.times(((Slot)that).value);
            if (newValue2.isDefined()) {
                return new Slot(((Slot)that).key, newValue2);
            }
        } else if (that instanceof Attr && (newValue = this.times(((Attr)that).value)).isDefined()) {
            return new Attr(((Attr)that).key, newValue);
        }
        return Item.absent();
    }

    public Value times(Value that) {
        if (that instanceof Expression) {
            return new TimesOperator(this, that);
        }
        return Value.absent();
    }

    @Override
    public Item divide(Item that) {
        Value newValue;
        if (that instanceof Value) {
            return this.divide((Value)that);
        }
        if (that instanceof Slot) {
            Value newValue2 = this.divide(((Slot)that).value);
            if (newValue2.isDefined()) {
                return new Slot(((Slot)that).key, newValue2);
            }
        } else if (that instanceof Attr && (newValue = this.divide(((Attr)that).value)).isDefined()) {
            return new Attr(((Attr)that).key, newValue);
        }
        return Item.absent();
    }

    public Value divide(Value that) {
        if (that instanceof Expression) {
            return new DivideOperator(this, that);
        }
        return Value.absent();
    }

    @Override
    public Item modulo(Item that) {
        Value newValue;
        if (that instanceof Value) {
            return this.modulo((Value)that);
        }
        if (that instanceof Slot) {
            Value newValue2 = this.modulo(((Slot)that).value);
            if (newValue2.isDefined()) {
                return new Slot(((Slot)that).key, newValue2);
            }
        } else if (that instanceof Attr && (newValue = this.modulo(((Attr)that).value)).isDefined()) {
            return new Attr(((Attr)that).key, newValue);
        }
        return Item.absent();
    }

    public Value modulo(Value that) {
        if (that instanceof Expression) {
            return new ModuloOperator(this, that);
        }
        return Value.absent();
    }

    @Override
    public Value not() {
        return Value.absent();
    }

    @Override
    public Value bitwiseNot() {
        return Value.absent();
    }

    @Override
    public Value negative() {
        return Value.absent();
    }

    @Override
    public Value positive() {
        return Value.absent();
    }

    @Override
    public Value inverse() {
        return Value.absent();
    }

    @Override
    public Value lambda(Value template) {
        return new LambdaFunc(this, template);
    }

    @Override
    public String stringValue() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String stringValue(String orElse) {
        return orElse;
    }

    @Override
    public byte byteValue() {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte byteValue(byte orElse) {
        return orElse;
    }

    @Override
    public short shortValue() {
        throw new UnsupportedOperationException();
    }

    @Override
    public short shortValue(short orElse) {
        return orElse;
    }

    @Override
    public int intValue() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int intValue(int orElse) {
        return orElse;
    }

    @Override
    public long longValue() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long longValue(long orElse) {
        return orElse;
    }

    @Override
    public float floatValue() {
        throw new UnsupportedOperationException();
    }

    @Override
    public float floatValue(float orElse) {
        return orElse;
    }

    @Override
    public double doubleValue() {
        throw new UnsupportedOperationException();
    }

    @Override
    public double doubleValue(double orElse) {
        return orElse;
    }

    @Override
    public BigInteger integerValue() {
        throw new UnsupportedOperationException();
    }

    @Override
    public BigInteger integerValue(BigInteger orElse) {
        return orElse;
    }

    @Override
    public Number numberValue() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Number numberValue(Number orElse) {
        return orElse;
    }

    @Override
    public char charValue() {
        throw new UnsupportedOperationException();
    }

    @Override
    public char charValue(char orElse) {
        return orElse;
    }

    @Override
    public boolean booleanValue() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean booleanValue(boolean orElse) {
        return orElse;
    }

    @Override
    public boolean isAliased() {
        return false;
    }

    @Override
    public boolean isMutable() {
        return false;
    }

    @Override
    public void alias() {
    }

    @Override
    public Value branch() {
        return this;
    }

    @Override
    public Value commit() {
        return this;
    }

    @Override
    public boolean keyEquals(Object key) {
        return false;
    }

    public static Builder<Item, Value> builder() {
        return new ValueBuilder();
    }

    public static Value empty() {
        return Record.empty();
    }

    public static Value extant() {
        return Extant.extant();
    }

    public static Value absent() {
        return Absent.absent();
    }

    public static Value fromObject(Object object) {
        if (object == null) {
            return Value.extant();
        }
        if (object instanceof Value) {
            return (Value)object;
        }
        if (object instanceof String) {
            return Text.from((String)object);
        }
        if (object instanceof Number) {
            return Num.from((Number)object);
        }
        if (object instanceof Character) {
            return Num.from(((Character)object).charValue());
        }
        if (object instanceof Boolean) {
            return Bool.from((Boolean)object);
        }
        if (object instanceof ByteBuffer) {
            return Data.from((ByteBuffer)object);
        }
        if (object instanceof byte[]) {
            return Data.wrap((byte[])object);
        }
        throw new IllegalArgumentException(object.toString());
    }
}

