/*
 * Decompiled with CFR 0.152.
 */
package swim.structure.form;

import java.math.BigInteger;
import swim.structure.Form;
import swim.structure.Item;
import swim.structure.Num;
import swim.structure.Value;

public final class BigIntegerForm
extends Form<BigInteger> {
    final BigInteger unit;

    public BigIntegerForm(BigInteger unit) {
        this.unit = unit;
    }

    @Override
    public BigInteger unit() {
        return this.unit;
    }

    @Override
    public Form<BigInteger> unit(BigInteger unit) {
        return new BigIntegerForm(unit);
    }

    @Override
    public Class<BigInteger> type() {
        return BigInteger.class;
    }

    @Override
    public Item mold(BigInteger value) {
        if (value != null) {
            return Num.from(value);
        }
        return Item.extant();
    }

    @Override
    public BigInteger cast(Item item) {
        Value value = item.target();
        try {
            return value.integerValue();
        }
        catch (UnsupportedOperationException e) {
            return null;
        }
    }
}

