/*
 * Decompiled with CFR 0.152.
 */
package swim.structure.form;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import swim.structure.Attr;
import swim.structure.Form;
import swim.structure.FormException;
import swim.structure.Item;
import swim.structure.Record;
import swim.structure.Text;
import swim.structure.Value;
import swim.structure.form.FieldForm;
import swim.structure.form.SlotForm;

public final class ClassForm<T>
extends Form<T>
implements Cloneable {
    final Class<?> type;
    final String tag;
    final T unit;
    final Constructor<T> constructor;
    Form<T>[] headers;
    Form<T>[] members;

    ClassForm(Class<?> type, String tag, T unit, Constructor<T> constructor, Form<T>[] headers, Form<T>[] members) {
        this.type = type;
        this.tag = tag;
        this.unit = unit;
        this.constructor = constructor;
        this.headers = headers;
        this.members = members;
    }

    public ClassForm(Class<?> type, String tag, T unit) {
        Constructor<?> constructor;
        this.type = type;
        this.tag = tag;
        this.unit = unit;
        try {
            constructor = type.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
        }
        catch (NoSuchMethodException cause) {
            constructor = null;
        }
        this.constructor = constructor;
        this.headers = new Form[0];
        this.members = new Form[0];
    }

    @Override
    public String tag() {
        return this.tag;
    }

    @Override
    public ClassForm<T> tag(String tag) {
        return new ClassForm<T>(this.type, tag, this.unit, this.constructor, this.headers, this.members);
    }

    @Override
    public T unit() {
        return this.unit;
    }

    @Override
    public ClassForm<T> unit(T unit) {
        return new ClassForm<T>(this.type, this.tag, unit, this.constructor, this.headers, this.members);
    }

    public ClassForm<T> addHeader(Form<T> header) {
        Form<T>[] oldHeaders = this.headers;
        int n = oldHeaders.length;
        Form[] newHeaders = new Form[n + 1];
        System.arraycopy(oldHeaders, 0, newHeaders, 0, n);
        newHeaders[n] = header;
        this.headers = newHeaders;
        return this;
    }

    public ClassForm<T> putHeader(Form<T> header) {
        if (header instanceof FieldForm) {
            String name = ((FieldForm)header).field().getName();
            Form<T>[] oldHeaders = this.headers;
            int n = oldHeaders.length;
            for (int i = 0; i < n; ++i) {
                Form<T> oldHeader = oldHeaders[i];
                if (!(oldHeader instanceof FieldForm) || !name.equals(((FieldForm)oldHeader).field().getName())) continue;
                Form[] newHeaders = new Form[n];
                System.arraycopy(oldHeaders, 0, newHeaders, 0, n);
                newHeaders[i] = header;
                this.headers = newHeaders;
                return this;
            }
        }
        return this.addHeader(header);
    }

    public ClassForm<T> putHeader(String name, Value key, Form<?> form) {
        try {
            Field field = this.type.getField(name);
            SlotForm header = new SlotForm(field, key, form);
            return this.putHeader(header);
        }
        catch (NoSuchFieldException cause) {
            throw new FormException(cause);
        }
    }

    public ClassForm<T> putHeader(String name, Form<?> form) {
        return this.putHeader(name, Text.from(name), form);
    }

    public ClassForm<T> addMember(Form<T> member) {
        Form<T>[] oldMembers = this.members;
        int n = oldMembers.length;
        Form[] newMembers = new Form[n + 1];
        System.arraycopy(oldMembers, 0, newMembers, 0, n);
        newMembers[n] = member;
        this.members = newMembers;
        return this;
    }

    public ClassForm<T> putMember(Form<T> member) {
        if (member instanceof FieldForm) {
            String name = ((FieldForm)member).field().getName();
            Form<T>[] oldMembers = this.members;
            int n = oldMembers.length;
            for (int i = 0; i < n; ++i) {
                Form<T> oldMember = oldMembers[i];
                if (!(oldMember instanceof FieldForm) || !name.equals(((FieldForm)oldMember).field().getName())) continue;
                Form[] newMembers = new Form[n];
                System.arraycopy(oldMembers, 0, newMembers, 0, n);
                newMembers[i] = member;
                this.members = newMembers;
                return this;
            }
        }
        return this.addMember(member);
    }

    public ClassForm<T> putMember(String name, Value key, Form<?> form) {
        try {
            Field field = this.type.getField(name);
            SlotForm member = new SlotForm(field, key, form);
            return this.putMember(member);
        }
        catch (NoSuchFieldException cause) {
            throw new FormException(cause);
        }
    }

    public ClassForm<T> putMember(String name, Form<?> form) {
        return this.putMember(name, Text.from(name), form);
    }

    @Override
    public Class<?> type() {
        return this.type;
    }

    @Override
    public Item mold(T object, Item item) {
        if (object != null) {
            Attr head;
            if (this.tag != null) {
                Value header = Value.absent();
                int n = this.headers.length;
                for (int i = 0; i < n; ++i) {
                    header = this.headers[i].mold(object, header).toValue();
                }
                if (!header.isDefined()) {
                    header = Value.extant();
                }
                head = Attr.of(this.tag, header);
            } else {
                head = null;
            }
            int n = this.members.length;
            for (int i = 0; i < n; ++i) {
                item = this.members[i].mold(object, item);
            }
            if (head != null) {
                item = item.prepended(head);
            }
        }
        return item;
    }

    @Override
    public Item mold(T object) {
        if (object != null) {
            Attr head;
            if (this.tag != null) {
                Value header = Value.absent();
                int n = this.headers.length;
                for (int i = 0; i < n; ++i) {
                    header = this.headers[i].mold(object, header).toValue();
                }
                if (!header.isDefined()) {
                    header = Value.extant();
                }
                head = Attr.of(this.tag, header);
            } else {
                head = null;
            }
            int n = this.members.length;
            Item item = Record.create(head != null ? 1 + n : n);
            for (int i = 0; i < n; ++i) {
                item = this.members[i].mold(object, item);
            }
            if (head != null) {
                item = ((Item)item).prepended(head);
            }
            return item;
        }
        return Item.extant();
    }

    @Override
    public T cast(Item item, T object) {
        Value value = item.toValue();
        if (this.tag != null) {
            Value header = value.header(this.tag);
            if (!header.isDefined()) {
                return null;
            }
            int n = this.headers.length;
            for (int i = 0; i < n; ++i) {
                object = this.headers[i].cast(header, object);
            }
        }
        int n = this.members.length;
        for (int i = 0; i < n; ++i) {
            object = this.members[i].cast(value, object);
        }
        return object;
    }

    @Override
    public T cast(Item item) {
        if (this.constructor != null) {
            try {
                T object = this.constructor.newInstance(new Object[0]);
                return this.cast(item, object);
            }
            catch (ReflectiveOperationException cause) {
                throw new FormException(cause);
            }
        }
        return null;
    }

    public ClassForm<T> clone() {
        return new ClassForm<T>(this.type, this.tag, this.unit, this.constructor, this.headers, this.members);
    }
}

