/*
 * Decompiled with CFR 0.152.
 */
package swim.structure.operator;

import swim.codec.Output;
import swim.structure.Interpreter;
import swim.structure.Item;
import swim.structure.Operator;
import swim.structure.operator.BinaryOperator;
import swim.util.Murmur3;

public final class NeOperator
extends BinaryOperator {
    private static int hashSeed;

    public NeOperator(Item lhs, Item rhs) {
        super(lhs, rhs);
    }

    @Override
    public String operator() {
        return "!=";
    }

    @Override
    public int precedence() {
        return 0;
    }

    @Override
    public Item evaluate(Interpreter interpreter) {
        interpreter.willOperate(this);
        Item lhs = this.lhs.evaluate(interpreter);
        Item rhs = this.rhs.evaluate(interpreter);
        Item result = lhs.ne(rhs);
        interpreter.didOperate(this, result);
        return result;
    }

    @Override
    public int typeOrder() {
        return 29;
    }

    @Override
    protected int compareTo(Operator that) {
        if (that instanceof NeOperator) {
            return this.compareTo((NeOperator)that);
        }
        return Integer.compare(this.typeOrder(), that.typeOrder());
    }

    @Override
    int compareTo(NeOperator that) {
        int order = this.lhs.compareTo(that.lhs);
        if (order == 0) {
            order = this.rhs.compareTo(that.rhs);
        }
        return order;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof NeOperator) {
            NeOperator that = (NeOperator)other;
            return this.lhs.equals(that.lhs) && this.rhs.equals(that.rhs);
        }
        return false;
    }

    @Override
    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(NeOperator.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)this.lhs.hashCode()), (int)this.rhs.hashCode()));
    }

    @Override
    public <T> Output<T> debug(Output<T> output) {
        output = output.debug((Object)this.lhs).write(46).write("ne").write(40).debug((Object)this.rhs).write(41);
        return output;
    }
}

