/*
 * Decompiled with CFR 0.152.
 */
package swim.structure.selector;

import swim.codec.Output;
import swim.structure.Interpreter;
import swim.structure.Item;
import swim.structure.Selectee;
import swim.structure.Selector;
import swim.util.Murmur3;

public final class LiteralSelector
extends Selector {
    final Item item;
    final Selector then;
    private static int hashSeed;

    public LiteralSelector(Item item, Selector then) {
        this.item = item.commit();
        this.then = then;
    }

    public Item item() {
        return this.item;
    }

    @Override
    public Selector then() {
        return this.then;
    }

    @Override
    public <T> T forSelected(Interpreter interpreter, Selectee<T> callback) {
        Item literal;
        T selected = null;
        interpreter.willSelect(this);
        if (interpreter.scopeDepth() != 0 && (literal = this.item.evaluate(interpreter)).isDefined()) {
            interpreter.pushScope(literal);
            selected = this.then.forSelected(interpreter, callback);
            interpreter.popScope();
        }
        interpreter.didSelect(this, selected);
        return selected;
    }

    @Override
    public Item mapSelected(Interpreter interpreter, Selectee<Item> transform) {
        Item result;
        interpreter.willTransform(this);
        if (interpreter.scopeDepth() != 0) {
            Item literal = this.item.evaluate(interpreter);
            if (literal.isDefined()) {
                interpreter.pushScope(literal);
                literal = this.then.mapSelected(interpreter, transform);
                interpreter.popScope();
            }
            result = literal;
        } else {
            result = Item.absent();
        }
        interpreter.didTransform(this, result);
        return result;
    }

    @Override
    public Item substitute(Interpreter interpreter) {
        Item item = this.item.substitute(interpreter);
        Item then = this.then.substitute(interpreter);
        if (!(then instanceof Selector)) {
            then = this.then;
        }
        return new LiteralSelector(item, (Selector)then);
    }

    @Override
    public Selector andThen(Selector then) {
        return new LiteralSelector(this.item, this.then.andThen(then));
    }

    @Override
    public int precedence() {
        return this.item.precedence();
    }

    @Override
    public int typeOrder() {
        return 11;
    }

    @Override
    protected int compareTo(Selector that) {
        if (that instanceof LiteralSelector) {
            return this.compareTo((LiteralSelector)that);
        }
        return Integer.compare(this.typeOrder(), that.typeOrder());
    }

    @Override
    int compareTo(LiteralSelector that) {
        int order = this.item.compareTo(that.item);
        if (order == 0) {
            order = this.then.compareTo((Item)that.then);
        }
        return order;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof LiteralSelector) {
            LiteralSelector that = (LiteralSelector)other;
            return this.item.equals(that.item) && this.then.equals(that.then);
        }
        return false;
    }

    @Override
    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(LiteralSelector.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)this.item.hashCode()), (int)this.then.hashCode()));
    }

    @Override
    public <T> Output<T> debug(Output<T> output) {
        output = output.write("Selector").write(46).write("literal").write(40).debug((Object)this.item).write(41);
        output = this.then.debugThen(output);
        return output;
    }

    @Override
    public <T> Output<T> debugThen(Output<T> output) {
        return output;
    }
}

