/*
 * Decompiled with CFR 0.152.
 */
package swim.uri;

import swim.codec.Diagnostic;
import swim.codec.Input;
import swim.codec.Parser;
import swim.uri.UriAuthority;
import swim.uri.UriHost;
import swim.uri.UriParser;
import swim.uri.UriPort;
import swim.uri.UriUser;

final class UriAuthorityParser
extends Parser<UriAuthority> {
    final UriParser uri;
    final Parser<UriUser> userParser;
    final Parser<UriHost> hostParser;
    final Parser<UriPort> portParser;
    final int step;

    UriAuthorityParser(UriParser uri, Parser<UriUser> userParser, Parser<UriHost> hostParser, Parser<UriPort> portParser, int step) {
        this.uri = uri;
        this.userParser = userParser;
        this.hostParser = hostParser;
        this.portParser = portParser;
        this.step = step;
    }

    UriAuthorityParser(UriParser uri) {
        this(uri, null, null, null, 1);
    }

    static Parser<UriAuthority> parse(Input input, UriParser uri, Parser<UriUser> userParser, Parser<UriHost> hostParser, Parser<UriPort> portParser, int step) {
        int c = 0;
        if (step == 1) {
            if (input.isCont()) {
                Input look = input.clone();
                while (look.isCont() && (c = look.head()) != 64 && c != 47) {
                    look = look.step();
                }
                step = look.isCont() && c == 64 ? 2 : 3;
            } else if (input.isDone()) {
                step = 3;
            }
        }
        if (step == 2) {
            if ((userParser = userParser == null ? uri.parseUser(input) : userParser.feed(input)).isDone()) {
                if (input.isCont() && input.head() == 64) {
                    input = input.step();
                    step = 3;
                } else if (!input.isEmpty()) {
                    return UriAuthorityParser.error((Diagnostic)Diagnostic.expected((int)64, (Input)input));
                }
            } else if (userParser.isError()) {
                return userParser.asError();
            }
        }
        if (step == 3) {
            if ((hostParser = hostParser == null ? uri.parseHost(input) : hostParser.feed(input)).isDone()) {
                if (input.isCont() && input.head() == 58) {
                    input = input.step();
                    step = 4;
                } else if (!input.isEmpty()) {
                    return UriAuthorityParser.done((Object)uri.authority(userParser != null ? (UriUser)userParser.bind() : null, (UriHost)hostParser.bind(), null));
                }
            } else if (hostParser.isError()) {
                return hostParser.asError();
            }
        }
        if (step == 4) {
            if ((portParser = portParser == null ? uri.parsePort(input) : portParser.feed(input)).isDone()) {
                return UriAuthorityParser.done((Object)uri.authority(userParser != null ? (UriUser)userParser.bind() : null, hostParser != null ? (UriHost)hostParser.bind() : null, (UriPort)portParser.bind()));
            }
            if (portParser.isError()) {
                return portParser.asError();
            }
        }
        if (input.isError()) {
            return UriAuthorityParser.error((Throwable)input.trap());
        }
        return new UriAuthorityParser(uri, (Parser<UriUser>)userParser, (Parser<UriHost>)hostParser, (Parser<UriPort>)portParser, step);
    }

    static Parser<UriAuthority> parse(Input input, UriParser uri) {
        return UriAuthorityParser.parse(input, uri, null, null, null, 1);
    }

    public Parser<UriAuthority> feed(Input input) {
        return UriAuthorityParser.parse(input, this.uri, this.userParser, this.hostParser, this.portParser, this.step);
    }
}

