/*
 * Decompiled with CFR 0.152.
 */
package swim.uri;

import swim.codec.Base16;
import swim.codec.Diagnostic;
import swim.codec.Input;
import swim.codec.Output;
import swim.codec.Parser;
import swim.codec.Utf8;
import swim.uri.Uri;
import swim.uri.UriFragment;
import swim.uri.UriParser;

final class UriFragmentParser
extends Parser<UriFragment> {
    final UriParser uri;
    final Output<String> output;
    final int c1;
    final int step;

    UriFragmentParser(UriParser uri, Output<String> output, int c1, int step) {
        this.uri = uri;
        this.output = output;
        this.c1 = c1;
        this.step = step;
    }

    UriFragmentParser(UriParser uri) {
        this(uri, null, 0, 1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Parser<UriFragment> parse(Input input, UriParser uri, Output<String> output, int c1, int step) {
        block12: {
            int c = 0;
            if (output == null) {
                output = Utf8.decodedString();
            }
            while (true) {
                if (step == 1) {
                    while (input.isCont() && Uri.isFragmentChar(c = input.head())) {
                        input = input.step();
                        output = output.write(c);
                    }
                    if (input.isCont() && c == 37) {
                        input = input.step();
                        step = 2;
                    } else if (!input.isEmpty()) {
                        return UriFragmentParser.done((Object)uri.fragment((String)output.bind()));
                    }
                }
                if (step == 2) {
                    if (input.isCont()) {
                        c = input.head();
                        if (!Base16.isDigit((int)c)) return UriFragmentParser.error((Diagnostic)Diagnostic.expected((String)"hex digit", (Input)input));
                        input = input.step();
                        c1 = c;
                        step = 3;
                    } else if (input.isDone()) {
                        return UriFragmentParser.error((Diagnostic)Diagnostic.expected((String)"hex digit", (Input)input));
                    }
                }
                if (step != 3) break block12;
                if (!input.isCont()) break;
                c = input.head();
                if (!Base16.isDigit((int)c)) return UriFragmentParser.error((Diagnostic)Diagnostic.expected((String)"hex digit", (Input)input));
                input = input.step();
                output = output.write(Base16.decodeDigit((int)c1) << 4 | Base16.decodeDigit((int)c));
                c1 = 0;
                step = 1;
            }
            if (input.isDone()) {
                return UriFragmentParser.error((Diagnostic)Diagnostic.expected((String)"hex digit", (Input)input));
            }
        }
        if (!input.isError()) return new UriFragmentParser(uri, (Output<String>)output, c1, step);
        return UriFragmentParser.error((Throwable)input.trap());
    }

    static Parser<UriFragment> parse(Input input, UriParser uri) {
        return UriFragmentParser.parse(input, uri, null, 0, 1);
    }

    public Parser<UriFragment> feed(Input input) {
        return UriFragmentParser.parse(input, this.uri, this.output, this.c1, this.step);
    }
}

