/*
 * Decompiled with CFR 0.152.
 */
package swim.uri;

import swim.codec.Diagnostic;
import swim.codec.Input;
import swim.codec.Output;
import swim.codec.Parser;
import swim.codec.Utf8;
import swim.uri.Uri;
import swim.uri.UriHost;
import swim.uri.UriParser;

final class UriHostLiteralParser
extends Parser<UriHost> {
    final UriParser uri;
    final Output<String> output;
    final int step;

    UriHostLiteralParser(UriParser uri, Output<String> output, int step) {
        this.uri = uri;
        this.output = output;
        this.step = step;
    }

    UriHostLiteralParser(UriParser uri) {
        this(uri, null, 1);
    }

    static Parser<UriHost> parse(Input input, UriParser uri, Output<String> output, int step) {
        int c = 0;
        if (step == 1) {
            if (input.isCont() && input.head() == 91) {
                input = input.step();
                step = 2;
            } else if (!input.isEmpty()) {
                return UriHostLiteralParser.error((Diagnostic)Diagnostic.expected((int)91, (Input)input));
            }
        }
        if (step == 2) {
            if (output == null) {
                output = Utf8.decodedString();
            }
            while (input.isCont() && (Uri.isHostChar(c = input.head()) || c == 58)) {
                input = input.step();
                output = output.write(Character.toLowerCase(c));
            }
            if (input.isCont() && c == 93) {
                input = input.step();
                return UriHostLiteralParser.done((Object)uri.hostIPv6((String)output.bind()));
            }
            if (!input.isEmpty()) {
                return UriHostLiteralParser.error((Diagnostic)Diagnostic.expected((int)93, (Input)input));
            }
        }
        if (input.isError()) {
            return UriHostLiteralParser.error((Throwable)input.trap());
        }
        return new UriHostLiteralParser(uri, (Output<String>)output, step);
    }

    static Parser<UriHost> parse(Input input, UriParser uri) {
        return UriHostLiteralParser.parse(input, uri, null, 1);
    }

    public Parser<UriHost> feed(Input input) {
        return UriHostLiteralParser.parse(input, this.uri, this.output, this.step);
    }
}

