/*
 * Decompiled with CFR 0.152.
 */
package swim.uri;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import swim.codec.Debug;
import swim.codec.Format;
import swim.codec.Output;
import swim.uri.Uri;
import swim.uri.UriEmptyMapping;
import swim.uri.UriMapperEntrySet;
import swim.uri.UriMapperKeySet;
import swim.uri.UriMapperValues;
import swim.uri.UriPart;
import swim.uri.UriPattern;
import swim.uri.UriSchemeMapper;

public abstract class UriMapper<T>
implements Iterable<Map.Entry<Uri, T>>,
Map<Uri, T>,
Debug {
    private static UriMapper<Object> empty;

    UriMapper() {
    }

    public static <T> UriMapper<T> empty() {
        if (empty == null) {
            empty = new UriEmptyMapping<Object>();
        }
        return empty;
    }

    public static <T> UriMapper<T> from(Uri pattern, T value) {
        return UriSchemeMapper.compile(pattern, pattern.scheme(), pattern.authority(), pattern.path(), pattern.query(), pattern.fragment(), value);
    }

    public static <T> UriMapper<T> from(UriPattern pattern, T value) {
        return UriMapper.from(pattern.toUri(), value);
    }

    public static <T> UriMapper<T> from(String uriString, T value) {
        return UriMapper.from(Uri.parse(uriString), value);
    }

    @Override
    public abstract boolean isEmpty();

    @Override
    public abstract int size();

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    @Override
    public abstract boolean containsValue(Object var1);

    public abstract UriMapper<T> getSuffix(Uri var1);

    public UriMapper<T> getSuffix(String uri) {
        return this.getSuffix(Uri.parse(uri));
    }

    public abstract T get(Uri var1);

    public T get(String uri) {
        return this.get(Uri.parse(uri));
    }

    @Override
    public T get(Object key) {
        if (key instanceof Uri) {
            return this.get((Uri)key);
        }
        if (key instanceof String) {
            return this.get((String)key);
        }
        return null;
    }

    @Override
    public T put(Uri pattern, T value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends Uri, ? extends T> map) {
        throw new UnsupportedOperationException();
    }

    @Override
    public T remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    public abstract UriMapper<T> merged(UriMapper<T> var1);

    public UriMapper<T> updated(Uri pattern, T value) {
        return this.merged(UriMapper.from(pattern, value));
    }

    public UriMapper<T> updated(UriPattern pattern, T value) {
        return this.updated(pattern.toUri(), value);
    }

    public UriMapper<T> updated(String pattern, T value) {
        return this.updated(Uri.parse(pattern), value);
    }

    public abstract UriMapper<T> removed(Uri var1);

    public UriMapper<T> removed(UriPattern pattern) {
        return this.removed(pattern.toUri());
    }

    public UriMapper<T> removed(String pattern) {
        return this.removed(Uri.parse(pattern));
    }

    public abstract UriMapper<T> unmerged(UriMapper<T> var1);

    @Override
    public Set<Map.Entry<Uri, T>> entrySet() {
        return new UriMapperEntrySet(this);
    }

    @Override
    public Set<Uri> keySet() {
        return new UriMapperKeySet(this);
    }

    @Override
    public Collection<T> values() {
        return new UriMapperValues(this);
    }

    @Override
    public abstract Iterator<Map.Entry<Uri, T>> iterator();

    public abstract Iterator<Uri> keyIterator();

    public abstract Iterator<T> valueIterator();

    public long childCount() {
        return 0L;
    }

    public Iterator<UriPart> childIterator() {
        return Collections.emptyIterator();
    }

    public void debug(Output<?> output) {
        output = output.write("UriMapper").write(46).write("empty").write(40).write(41);
        for (Map.Entry<Uri, T> from : this) {
            output = output.write(46).write("updated").write(40).debug((Object)from.getKey().toString()).write(", ").debug(from.getValue()).write(41);
        }
    }

    public String toString() {
        return Format.debug((Object)this);
    }
}

