/*
 * Decompiled with CFR 0.152.
 */
package swim.uri;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import swim.codec.Debug;
import swim.codec.Display;
import swim.codec.Output;
import swim.structure.Form;
import swim.structure.Kind;
import swim.uri.Uri;
import swim.uri.UriPart;
import swim.uri.UriPathBuilder;
import swim.uri.UriPathEmpty;
import swim.uri.UriPathForm;
import swim.uri.UriPathIterator;
import swim.uri.UriPathSegment;
import swim.uri.UriPathSlash;
import swim.util.HashGenCacheSet;
import swim.util.Murmur3;

public abstract class UriPath
extends UriPart
implements Collection<String>,
Comparable<UriPath>,
Debug,
Display {
    private static UriPath empty;
    private static UriPath slash;
    private static ThreadLocal<HashGenCacheSet<String>> segmentCache;
    private static Form<UriPath> pathForm;

    UriPath() {
    }

    private static int size(UriPath path) {
        int n = 0;
        while (!path.isEmpty()) {
            ++n;
            path = path.tail();
        }
        return n;
    }

    private static String name(UriPath path) {
        if (path.isEmpty()) {
            return "";
        }
        UriPath tail;
        while (!(tail = path.tail()).isEmpty()) {
            path = tail;
        }
        return path.isRelative() ? path.head() : "";
    }

    private static UriPath foot(UriPath path) {
        if (path.isEmpty()) {
            return path;
        }
        UriPath tail;
        while (!(tail = path.tail()).isEmpty()) {
            path = tail;
        }
        return path;
    }

    private static boolean isRelativeTo(UriPath a, UriPath b) {
        while (!a.isEmpty() && !b.isEmpty()) {
            if (!a.head().equals(b.head())) {
                return false;
            }
            a = a.tail();
            b = b.tail();
        }
        return b.isEmpty();
    }

    private static boolean isChildOf(UriPath a, UriPath b) {
        while (!a.isEmpty() && !b.isEmpty()) {
            if (!a.head().equals(b.head())) {
                return false;
            }
            a = a.tail();
            b = b.tail();
        }
        return b.isEmpty() && !a.isEmpty() && a.tail().isEmpty();
    }

    private static boolean contains(UriPath path, String component) {
        while (!path.isEmpty()) {
            if (component.equals(path.head())) {
                return true;
            }
            path = path.tail();
        }
        return false;
    }

    private static boolean containsAll(UriPath path, HashSet<?> missing) {
        while (!path.isEmpty() && !missing.isEmpty()) {
            missing.remove(path.head());
            path = path.tail();
        }
        return missing.isEmpty();
    }

    private static UriPath removeDotSegments(UriPath path, UriPathBuilder builder) {
        while (!path.isEmpty()) {
            String head = path.head();
            if (head.equals(".") || head.equals("..")) {
                if ((path = path.tail()).isEmpty()) continue;
                path = path.tail();
                continue;
            }
            if (path.isAbsolute()) {
                UriPath rest = path.tail();
                if (!rest.isEmpty()) {
                    String next = rest.head();
                    if (next.equals(".")) {
                        path = rest.tail();
                        if (!path.isEmpty()) continue;
                        path = UriPath.slash();
                        continue;
                    }
                    if (next.equals("..")) {
                        path = rest.tail();
                        if (path.isEmpty()) {
                            path = UriPath.slash();
                        }
                        if (builder.isEmpty() || builder.pop().isAbsolute() || builder.isEmpty()) continue;
                        builder.pop();
                        continue;
                    }
                    builder.add(head);
                    builder.add(next);
                    path = rest.tail();
                    continue;
                }
                builder.add(path.head());
                path = path.tail();
                continue;
            }
            builder.add(path.head());
            path = path.tail();
        }
        return builder.bind();
    }

    static UriPath merge(UriPath prev, UriPath that) {
        UriPath next;
        UriPathBuilder builder = new UriPathBuilder();
        while (!(next = prev.tail()).isEmpty()) {
            if (prev.isAbsolute()) {
                builder.addSlash();
            } else {
                builder.addSegment(prev.head());
            }
            prev = next;
        }
        if (prev.isAbsolute()) {
            builder.addSlash();
        }
        builder.addPath(that);
        return builder.bind();
    }

    private static UriPath unmerge(UriPath base, UriPath relative, UriPath root) {
        while (true) {
            if (base.isEmpty()) {
                if (!relative.isEmpty() && !relative.tail().isEmpty()) {
                    return relative.tail();
                }
                return relative;
            }
            if (base.isRelative()) {
                return relative;
            }
            if (relative.isRelative()) {
                return UriPath.slash(relative);
            }
            UriPath a = base.tail();
            UriPath b = relative.tail();
            if (!a.isEmpty() && b.isEmpty()) {
                return UriPath.slash();
            }
            if (a.isEmpty() || b.isEmpty() || !a.head().equals(b.head())) {
                return b;
            }
            a = a.tail();
            b = b.tail();
            if (!a.isEmpty() && b.isEmpty()) {
                return root;
            }
            base = a;
            relative = b;
        }
    }

    private static void toArray(UriPath path, Object[] array) {
        int i = 0;
        while (!path.isEmpty()) {
            array[i] = path.head();
            path = path.tail();
            ++i;
        }
    }

    static void display(UriPath path, Output<?> output) {
        while (!path.isEmpty()) {
            if (path.isAbsolute()) {
                output = output.write(47);
            } else {
                Uri.writePathSegment(path.head(), output);
            }
            path = path.tail();
        }
    }

    public static UriPathBuilder builder() {
        return new UriPathBuilder();
    }

    public static UriPath empty() {
        if (empty == null) {
            empty = new UriPathEmpty();
        }
        return empty;
    }

    public static UriPath slash() {
        if (slash == null) {
            slash = new UriPathSlash(UriPath.empty());
        }
        return slash;
    }

    static UriPath slash(UriPath tail) {
        if (tail == empty) {
            return UriPath.slash();
        }
        return new UriPathSlash(tail);
    }

    public static UriPath segment(String segment) {
        return UriPath.segment(segment, UriPath.empty());
    }

    static UriPath segment(String segment, UriPath tail) {
        if (segment == null) {
            throw new NullPointerException("segment");
        }
        segment = UriPath.cacheSegment(segment);
        return new UriPathSegment(segment, tail);
    }

    public static UriPath component(String component) {
        return UriPath.component(component, UriPath.empty());
    }

    static UriPath component(String component, UriPath tail) {
        if (component == null) {
            throw new NullPointerException();
        }
        if (component.equals("/")) {
            return UriPath.slash();
        }
        return UriPath.segment(component);
    }

    public static UriPath from(String ... components) {
        if (components == null) {
            throw new NullPointerException();
        }
        UriPathBuilder builder = new UriPathBuilder();
        int n = components.length;
        for (int i = 0; i < n; ++i) {
            builder.add(components[i]);
        }
        return builder.bind();
    }

    public static UriPath from(Collection<? extends String> components) {
        if (components == null) {
            throw new NullPointerException();
        }
        if (components instanceof UriPath) {
            return (UriPath)components;
        }
        UriPathBuilder builder = new UriPathBuilder();
        builder.addAll(components);
        return builder.bind();
    }

    public static UriPath parse(String string) {
        return Uri.standardParser().parsePathString(string);
    }

    static HashGenCacheSet<String> segmentCache() {
        HashGenCacheSet segmentCache = UriPath.segmentCache.get();
        if (segmentCache == null) {
            int segmentCacheSize;
            try {
                segmentCacheSize = Integer.parseInt(System.getProperty("swim.uri.segment.cache.size"));
            }
            catch (NumberFormatException e) {
                segmentCacheSize = 64;
            }
            segmentCache = new HashGenCacheSet(segmentCacheSize);
            UriPath.segmentCache.set((HashGenCacheSet<String>)segmentCache);
        }
        return segmentCache;
    }

    static String cacheSegment(String segment) {
        if (segment.length() <= 32) {
            return (String)UriPath.segmentCache().put((Object)segment);
        }
        return segment;
    }

    @Kind
    public static Form<UriPath> pathForm() {
        if (pathForm == null) {
            pathForm = new UriPathForm(UriPath.empty());
        }
        return pathForm;
    }

    public abstract boolean isDefined();

    public abstract boolean isAbsolute();

    public abstract boolean isRelative();

    @Override
    public abstract boolean isEmpty();

    @Override
    public int size() {
        return UriPath.size(this);
    }

    public abstract String head();

    public abstract UriPath tail();

    abstract void setTail(UriPath var1);

    abstract UriPath dealias();

    public abstract UriPath parent();

    public abstract UriPath base();

    public String name() {
        return UriPath.name(this);
    }

    public UriPath name(String name) {
        UriPathBuilder builder = new UriPathBuilder();
        builder.addPath(this.base());
        builder.addSegment(name);
        return builder.bind();
    }

    public abstract UriPath body();

    public UriPath foot() {
        return UriPath.foot(this);
    }

    public boolean isRelativeTo(UriPath b) {
        return UriPath.isRelativeTo(this, b);
    }

    public boolean isChildOf(UriPath b) {
        return UriPath.isChildOf(this, b);
    }

    @Override
    public boolean contains(Object component) {
        if (component instanceof String) {
            return UriPath.contains(this, (String)component);
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> components) {
        if (components == null) {
            throw new NullPointerException();
        }
        return UriPath.containsAll(this, new HashSet(components));
    }

    @Override
    public boolean add(String component) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends String> components) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object component) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> components) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> components) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    public UriPath appended(String component) {
        if (component == null) {
            throw new NullPointerException();
        }
        if (component.equals("/")) {
            return this.appendedSlash();
        }
        return this.appendedSegment(component);
    }

    public UriPath appended(String ... components) {
        return this.appended(UriPath.from(components));
    }

    public UriPath appended(Collection<? extends String> components) {
        if (!components.isEmpty()) {
            UriPathBuilder builder = new UriPathBuilder();
            builder.addPath(this);
            builder.addAll(components);
            return builder.bind();
        }
        return this;
    }

    public UriPath appendedSlash() {
        UriPathBuilder builder = new UriPathBuilder();
        builder.addPath(this);
        builder.addSlash();
        return builder.bind();
    }

    public UriPath appendedSegment(String segment) {
        UriPathBuilder builder = new UriPathBuilder();
        builder.addPath(this);
        builder.addSegment(segment);
        return builder.bind();
    }

    public UriPath prepended(String component) {
        if (component == null) {
            throw new NullPointerException();
        }
        if (component.equals("/")) {
            return this.prependedSlash();
        }
        return this.prependedSegment(component);
    }

    public UriPath prepended(String ... components) {
        return this.prepended(UriPath.from(components));
    }

    public UriPath prepended(Collection<? extends String> components) {
        if (!components.isEmpty()) {
            UriPathBuilder builder = new UriPathBuilder();
            builder.addAll(components);
            builder.addPath(this);
            return builder.bind();
        }
        return this;
    }

    public UriPath prependedSlash() {
        return UriPath.slash(this);
    }

    public UriPath prependedSegment(String segment) {
        if (this.isEmpty() || this.isAbsolute()) {
            return UriPath.segment(segment, this);
        }
        return UriPath.segment(segment, UriPath.slash(this));
    }

    public UriPath resolve(UriPath that) {
        if (that.isEmpty()) {
            return this;
        }
        if (that.isAbsolute() || this.isEmpty()) {
            return that.removeDotSegments();
        }
        return this.merge(that).removeDotSegments();
    }

    public UriPath removeDotSegments() {
        return UriPath.removeDotSegments(this, new UriPathBuilder());
    }

    public UriPath merge(UriPath that) {
        if (that == null) {
            throw new NullPointerException();
        }
        if (!this.isEmpty()) {
            return UriPath.merge(this, that);
        }
        return that;
    }

    public UriPath unmerge(UriPath that) {
        return UriPath.unmerge(this, that, that);
    }

    @Override
    public Object[] toArray() {
        Object[] array = new Object[this.size()];
        UriPath.toArray(this, array);
        return array;
    }

    @Override
    public <T> T[] toArray(T[] array) {
        int n = this.size();
        if (array.length < n) {
            array = (Object[])Array.newInstance(array.getClass().getComponentType(), n);
        }
        UriPath.toArray(this, array);
        if (array.length > n) {
            array[n] = null;
        }
        return array;
    }

    @Override
    public Iterator<String> iterator() {
        return new UriPathIterator(this);
    }

    @Override
    public final int compareTo(UriPath that) {
        return this.toString().compareTo(that.toString());
    }

    @Override
    public final boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof UriPath) {
            return this.toString().equals(((UriPath)other).toString());
        }
        return false;
    }

    @Override
    public final int hashCode() {
        return Murmur3.seed((String)this.toString());
    }

    public abstract void debug(Output<?> var1);

    public abstract void display(Output<?> var1);

    public abstract String toString();

    static {
        segmentCache = new ThreadLocal();
    }
}

