/*
 * Decompiled with CFR 0.152.
 */
package swim.uri;

import swim.codec.ParserException;
import swim.structure.Form;
import swim.structure.Item;
import swim.structure.Text;
import swim.structure.Value;
import swim.uri.UriException;
import swim.uri.UriPath;

public class UriPathForm
extends Form<UriPath> {
    final UriPath unit;

    UriPathForm(UriPath unit) {
        this.unit = unit;
    }

    public UriPath unit() {
        return this.unit;
    }

    public Form<UriPath> unit(UriPath unit) {
        return new UriPathForm(unit);
    }

    public Class<UriPath> type() {
        return UriPath.class;
    }

    public Item mold(UriPath value) {
        if (value != null) {
            return Text.from((String)value.toString());
        }
        return Item.extant();
    }

    public UriPath cast(Item item) {
        Value value = item.target();
        try {
            String string = value.stringValue();
            if (string != null) {
                return UriPath.parse(string);
            }
        }
        catch (UnsupportedOperationException | ParserException | UriException throwable) {
            // empty catch block
        }
        return null;
    }
}

