/*
 * Decompiled with CFR 0.152.
 */
package swim.uri;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import swim.uri.UriQuery;
import swim.uri.UriQueryValueIterator;

final class UriQueryValues
implements Collection<String> {
    final UriQuery query;

    UriQueryValues(UriQuery query) {
        this.query = query;
    }

    private static boolean containsAll(UriQuery query, HashSet<?> missing) {
        while (!query.isEmpty() && !missing.isEmpty()) {
            missing.remove(query.value());
            query = query.tail();
        }
        return missing.isEmpty();
    }

    private static void toArray(UriQuery query, Object[] array) {
        int i = 0;
        while (!query.isEmpty()) {
            array[i] = query.value();
            query = query.tail();
            ++i;
        }
    }

    private static String toString(UriQuery query) {
        StringBuilder s = new StringBuilder();
        s.append('[');
        if (!query.isEmpty()) {
            s.append(String.valueOf(query.value()));
            query = query.tail();
            while (!query.isEmpty()) {
                s.append(", ").append(String.valueOf(query.value()));
                query = query.tail();
            }
        }
        s.append(']');
        return s.toString();
    }

    @Override
    public boolean isEmpty() {
        return this.query.isEmpty();
    }

    @Override
    public int size() {
        return this.query.size();
    }

    @Override
    public boolean contains(Object value) {
        return this.query.containsValue(value);
    }

    @Override
    public boolean containsAll(Collection<?> values) {
        if (values == null) {
            throw new NullPointerException();
        }
        return UriQueryValues.containsAll(this.query, new HashSet(values));
    }

    @Override
    public boolean add(String value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends String> values) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> values) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> values) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<String> iterator() {
        return new UriQueryValueIterator(this.query);
    }

    @Override
    public Object[] toArray() {
        Object[] array = new Object[this.size()];
        UriQueryValues.toArray(this.query, array);
        return array;
    }

    @Override
    public <T> T[] toArray(T[] array) {
        int n = this.size();
        if (array.length < n) {
            array = (Object[])Array.newInstance(array.getClass().getComponentType(), n);
        }
        UriQueryValues.toArray(this.query, array);
        if (array.length > n) {
            array[n] = null;
        }
        return array;
    }

    public String toString() {
        return UriQueryValues.toString(this.query);
    }
}

