/*
 * Decompiled with CFR 0.152.
 */
package swim.uri;

import swim.collections.HashTrieMap;
import swim.uri.Uri;
import swim.uri.UriAuthority;
import swim.uri.UriAuthorityPattern;
import swim.uri.UriFragment;
import swim.uri.UriPath;
import swim.uri.UriPattern;
import swim.uri.UriQuery;
import swim.uri.UriScheme;
import swim.uri.UriSchemeLiteral;

abstract class UriSchemePattern
extends UriPattern {
    UriSchemePattern() {
    }

    static UriSchemePattern compile(Uri pattern, UriScheme scheme, UriAuthority authority, UriPath path, UriQuery query, UriFragment fragment) {
        if (scheme.isDefined()) {
            return new UriSchemeLiteral(scheme, UriAuthorityPattern.compile(pattern, authority, path, query, fragment));
        }
        return UriAuthorityPattern.compile(pattern, authority, path, query, fragment);
    }

    abstract HashTrieMap<String, String> unapply(UriScheme var1, UriAuthority var2, UriPath var3, UriQuery var4, UriFragment var5, HashTrieMap<String, String> var6);

    @Override
    public HashTrieMap<String, String> unapply(Uri uri, HashTrieMap<String, String> args) {
        return this.unapply(uri.scheme(), uri.authority(), uri.path(), uri.query(), uri.fragment(), args);
    }

    abstract boolean matches(UriScheme var1, UriAuthority var2, UriPath var3, UriQuery var4, UriFragment var5);

    @Override
    public boolean matches(Uri uri) {
        return this.matches(uri.scheme(), uri.authority(), uri.path(), uri.query(), uri.fragment());
    }
}

