/*
 * Decompiled with CFR 0.152.
 */
package swim.uri;

import swim.collections.HashTrieMap;
import swim.uri.Uri;
import swim.uri.UriAuthority;
import swim.uri.UriAuthorityLiteral;
import swim.uri.UriFragment;
import swim.uri.UriPath;
import swim.uri.UriPathPattern;
import swim.uri.UriQuery;
import swim.uri.UriScheme;
import swim.uri.UriSchemePattern;

abstract class UriAuthorityPattern
extends UriSchemePattern {
    UriAuthorityPattern() {
    }

    static UriAuthorityPattern compile(Uri pattern, UriAuthority authority, UriPath path, UriQuery query, UriFragment fragment) {
        if (authority.isDefined()) {
            return new UriAuthorityLiteral(authority, UriPathPattern.compile(pattern, path, query, fragment));
        }
        return UriPathPattern.compile(pattern, path, query, fragment);
    }

    abstract HashTrieMap<String, String> unapply(UriAuthority var1, UriPath var2, UriQuery var3, UriFragment var4, HashTrieMap<String, String> var5);

    @Override
    HashTrieMap<String, String> unapply(UriScheme scheme, UriAuthority authority, UriPath path, UriQuery query, UriFragment fragment, HashTrieMap<String, String> args) {
        return this.unapply(authority, path, query, fragment, args);
    }

    abstract boolean matches(UriAuthority var1, UriPath var2, UriQuery var3, UriFragment var4);

    @Override
    boolean matches(UriScheme scheme, UriAuthority authority, UriPath path, UriQuery query, UriFragment fragment) {
        if (!scheme.isDefined()) {
            return this.matches(authority, path, query, fragment);
        }
        return false;
    }
}

