/*
 * Decompiled with CFR 0.152.
 */
package swim.uri;

import java.util.Iterator;
import java.util.Map;
import swim.uri.Uri;
import swim.uri.UriConstantMappingIterator;
import swim.uri.UriConstantMappingKeyIterator;
import swim.uri.UriConstantMappingValueIterator;
import swim.uri.UriMapper;
import swim.uri.UriTerminalMapper;
import swim.util.Murmur3;

final class UriConstantMapping<T>
extends UriTerminalMapper<T> {
    private static int hashSeed;
    final Uri key;
    final T value;

    UriConstantMapping(Uri key, T value) {
        this.key = key;
        this.value = value;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public boolean containsValue(Object value) {
        return value == null ? this.value == null : value.equals(this.value);
    }

    @Override
    UriMapper<T> getSuffix() {
        return this;
    }

    @Override
    T get() {
        return this.value;
    }

    @Override
    public Iterator<Map.Entry<Uri, T>> iterator() {
        return new UriConstantMappingIterator<T>(this.key, this.value);
    }

    @Override
    public Iterator<Uri> keyIterator() {
        return new UriConstantMappingKeyIterator(this.key);
    }

    @Override
    public Iterator<T> valueIterator() {
        return new UriConstantMappingValueIterator<T>(this.value);
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof UriConstantMapping) {
            UriConstantMapping that = (UriConstantMapping)other;
            return this.value.equals(that.value);
        }
        return false;
    }

    @Override
    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(UriConstantMapping.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)hashSeed, (int)this.value.hashCode()));
    }
}

