/*
 * Decompiled with CFR 0.152.
 */
package swim.uri;

import swim.collections.HashTrieMap;
import swim.uri.Uri;
import swim.uri.UriAuthority;
import swim.uri.UriAuthorityMapper;
import swim.uri.UriFragment;
import swim.uri.UriMapper;
import swim.uri.UriPath;
import swim.uri.UriPathMapping;
import swim.uri.UriQuery;
import swim.uri.UriQueryMapper;

abstract class UriPathMapper<T>
extends UriAuthorityMapper<T> {
    UriPathMapper() {
    }

    static <T> UriPathMapper<T> compile(Uri pattern, UriPath path, UriQuery query, UriFragment fragment, T value) {
        if (!path.isEmpty()) {
            String segment = path.head();
            if (!segment.isEmpty() && segment.charAt(0) == ':') {
                return new UriPathMapping<T>(HashTrieMap.empty(), UriPathMapper.compile(pattern, path.tail(), query, fragment, value), (UriQueryMapper)UriPathMapper.empty());
            }
            return new UriPathMapping(HashTrieMap.empty().updated((Object)segment, UriPathMapper.compile(pattern, path.tail(), query, fragment, value)), (UriPathMapper)UriPathMapper.empty(), (UriQueryMapper)UriPathMapper.empty());
        }
        return new UriPathMapping<T>(HashTrieMap.empty(), (UriPathMapper)UriPathMapper.empty(), UriQueryMapper.compile(pattern, query, fragment, value));
    }

    abstract UriMapper<T> getSuffix(UriPath var1, UriQuery var2, UriFragment var3);

    @Override
    UriMapper<T> getSuffix(UriAuthority authority, UriPath path, UriQuery query, UriFragment fragment) {
        return this.getSuffix(path, query, fragment);
    }

    abstract T get(UriPath var1, UriQuery var2, UriFragment var3);

    @Override
    T get(UriAuthority authority, UriPath path, UriQuery query, UriFragment fragment) {
        return this.get(path, query, fragment);
    }

    @Override
    abstract UriPathMapper<T> merged(UriPathMapper<T> var1);

    @Override
    UriAuthorityMapper<T> merged(UriAuthorityMapper<T> that) {
        if (that instanceof UriPathMapper) {
            return this.merged((UriPathMapper)that);
        }
        return that;
    }

    abstract UriPathMapper<T> removed(UriPath var1, UriQuery var2, UriFragment var3);

    @Override
    UriAuthorityMapper<T> removed(UriAuthority authority, UriPath path, UriQuery query, UriFragment fragment) {
        return this.removed(path, query, fragment);
    }

    @Override
    abstract UriPathMapper<T> unmerged(UriPathMapper<T> var1);

    @Override
    UriAuthorityMapper<T> unmerged(UriAuthorityMapper<T> that) {
        if (that instanceof UriPathMapper) {
            return this.unmerged((UriPathMapper)that);
        }
        return this;
    }
}

