/*
 * Decompiled with CFR 0.152.
 */
package swim.uri;

import swim.codec.Format;
import swim.codec.Output;
import swim.uri.UriPath;

final class UriPathSegment
extends UriPath {
    final String head;
    UriPath tail;
    String string;

    UriPathSegment(String head, UriPath tail) {
        if (head.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.head = head;
        this.tail = tail;
    }

    @Override
    public boolean isDefined() {
        return true;
    }

    @Override
    public boolean isAbsolute() {
        return false;
    }

    @Override
    public boolean isRelative() {
        return true;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public String head() {
        return this.head;
    }

    @Override
    public UriPath tail() {
        return this.tail;
    }

    @Override
    void setTail(UriPath tail) {
        if (tail instanceof UriPathSegment) {
            throw new UnsupportedOperationException();
        }
        this.tail = tail;
    }

    @Override
    UriPath dealias() {
        return new UriPathSegment(this.head, this.tail);
    }

    @Override
    public UriPath parent() {
        UriPath tail = this.tail;
        if (tail.isEmpty()) {
            return UriPath.empty();
        }
        UriPath next = tail.tail();
        if (next.isEmpty()) {
            return UriPath.empty();
        }
        return new UriPathSegment(this.head, tail.parent());
    }

    @Override
    public UriPath base() {
        UriPath tail = this.tail;
        if (tail.isEmpty()) {
            return UriPath.empty();
        }
        return new UriPathSegment(this.head, tail.base());
    }

    @Override
    public UriPath body() {
        UriPath tail = this.tail;
        if (tail.isEmpty()) {
            return UriPath.empty();
        }
        return new UriPathSegment(this.head, tail.body());
    }

    @Override
    public UriPath prependedSegment(String segment) {
        return UriPath.segment(segment, UriPath.slash(this));
    }

    @Override
    public UriPath merge(UriPath that) {
        if (that == null) {
            throw new NullPointerException();
        }
        return UriPath.merge(this, that);
    }

    @Override
    public void debug(Output<?> output) {
        output = output.write("UriPath").write(46).write("parse").write(40).write(34).display((Object)this).write(34).write(41);
    }

    @Override
    public void display(Output<?> output) {
        if (this.string != null) {
            output = output.write(this.string);
        } else {
            UriPath.display(this, output);
        }
    }

    @Override
    public String toString() {
        if (this.string == null) {
            this.string = Format.display((Object)this);
        }
        return this.string;
    }
}

