/*
 * Decompiled with CFR 0.152.
 */
package swim.uri;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import swim.uri.UriQuery;
import swim.uri.UriQueryEntryIterator;

final class UriQueryEntrySet
implements Set<Map.Entry<String, String>> {
    final UriQuery query;

    UriQueryEntrySet(UriQuery query) {
        this.query = query;
    }

    private static boolean contains(UriQuery query, Map.Entry<?, ?> entry) {
        while (!query.isEmpty()) {
            if ((query.key() == null ? entry.getKey() == null : query.key().equals(entry.getKey())) && (query.value() == null ? entry.getValue() == null : query.value().equals(entry.getValue()))) {
                return true;
            }
            query = query.tail();
        }
        return false;
    }

    private static void toArray(UriQuery query, Object[] array) {
        int i = 0;
        while (!query.isEmpty()) {
            array[i] = query.head();
            query = query.tail();
            ++i;
        }
    }

    static boolean equals(UriQuery query, Set<?> that) {
        while (!query.isEmpty()) {
            if (!that.contains(query.head())) {
                return false;
            }
            query = query.tail();
        }
        return true;
    }

    static int hashCode(UriQuery query) {
        int code = 0;
        while (!query.isEmpty()) {
            String key = query.key();
            String value = query.value();
            code += (key == null ? 0 : key.hashCode()) ^ (value == null ? 0 : value.hashCode());
            query = query.tail();
        }
        return code;
    }

    private static String toString(UriQuery query) {
        StringBuilder s = new StringBuilder();
        s.append('[');
        if (!query.isEmpty()) {
            s.append(query.head().toString());
            query = query.tail();
            while (!query.isEmpty()) {
                s.append(", ").append(query.head().toString());
                query = query.tail();
            }
        }
        s.append(']');
        return s.toString();
    }

    @Override
    public boolean isEmpty() {
        return this.query.isEmpty();
    }

    @Override
    public int size() {
        return this.query.size();
    }

    @Override
    public boolean contains(Object entry) {
        if (entry instanceof Map.Entry) {
            return UriQueryEntrySet.contains(this.query, (Map.Entry)entry);
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> entries) {
        for (Object entry : entries) {
            if (this.contains(entry)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean add(Map.Entry<String, String> entry) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends Map.Entry<String, String>> entries) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object entry) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> entries) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> entries) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<Map.Entry<String, String>> iterator() {
        return new UriQueryEntryIterator(this.query);
    }

    @Override
    public Object[] toArray() {
        Object[] array = new Object[this.size()];
        UriQueryEntrySet.toArray(this.query, array);
        return array;
    }

    @Override
    public <T> T[] toArray(T[] array) {
        int n = this.size();
        if (array.length < n) {
            array = (Object[])Array.newInstance(array.getClass().getComponentType(), n);
        }
        UriQueryEntrySet.toArray(this.query, array);
        if (array.length > n) {
            array[n] = null;
        }
        return array;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Set) {
            Set that = (Set)other;
            if (this.size() == that.size()) {
                return UriQueryEntrySet.equals(this.query, that);
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        return UriQueryEntrySet.hashCode(this.query);
    }

    public String toString() {
        return UriQueryEntrySet.toString(this.query);
    }
}

