/*
 * Decompiled with CFR 0.152.
 */
package swim.uri;

import swim.codec.Debug;
import swim.codec.Display;
import swim.codec.Format;
import swim.codec.Output;
import swim.uri.Uri;
import swim.uri.UriHost;
import swim.uri.UriPart;
import swim.uri.UriPort;
import swim.uri.UriUser;
import swim.util.Murmur3;

public class UriAuthority
extends UriPart
implements Comparable<UriAuthority>,
Debug,
Display {
    protected final UriUser user;
    protected final UriHost host;
    protected final UriPort port;
    String string;
    private static UriAuthority undefined;

    protected UriAuthority(UriUser user, UriHost host, UriPort port) {
        this.user = user;
        this.host = host;
        this.port = port;
    }

    public final boolean isDefined() {
        return this.user.isDefined() || this.host.isDefined() || this.port.isDefined();
    }

    public final UriUser user() {
        return this.user;
    }

    public UriAuthority user(UriUser user) {
        if (user != this.user) {
            return this.copy(user, this.host, this.port);
        }
        return this;
    }

    public final String userPart() {
        return this.user.toString();
    }

    public UriAuthority userPart(String user) {
        return this.user(UriUser.parse(user));
    }

    public String username() {
        return this.user.username();
    }

    public UriAuthority username(String username) {
        return this.user(this.user.username(username));
    }

    public UriAuthority username(String username, String password) {
        return this.user(UriUser.create(username, password));
    }

    public String password() {
        return this.user.password();
    }

    public UriAuthority password(String password) {
        return this.user(this.user.password(password));
    }

    public final UriHost host() {
        return this.host;
    }

    public UriAuthority host(UriHost host) {
        if (host != this.host) {
            return this.copy(this.user, host, this.port);
        }
        return this;
    }

    public final String hostPart() {
        return this.host.toString();
    }

    public UriAuthority hostPart(String host) {
        return this.host(UriHost.parse(host));
    }

    public final String hostAddress() {
        return this.host.address();
    }

    public final String hostName() {
        return this.host.name();
    }

    public UriAuthority hostName(String address) {
        return this.host(UriHost.name(address));
    }

    public final String hostIPv4() {
        return this.host.ipv4();
    }

    public UriAuthority hostIPv4(String address) {
        return this.host(UriHost.ipv4(address));
    }

    public final String hostIPv6() {
        return this.host.ipv6();
    }

    public UriAuthority hostIPv6(String address) {
        return this.host(UriHost.ipv6(address));
    }

    public final UriPort port() {
        return this.port;
    }

    public UriAuthority port(UriPort port) {
        if (port != this.port) {
            return this.copy(this.user, this.host, port);
        }
        return this;
    }

    public final String portPart() {
        return this.port.toString();
    }

    public UriAuthority portPart(String port) {
        return this.port(UriPort.parse(port));
    }

    public final int portNumber() {
        return this.port.number();
    }

    public UriAuthority portNumber(int number) {
        return this.port(UriPort.create(number));
    }

    protected UriAuthority copy(UriUser user, UriHost host, UriPort port) {
        return UriAuthority.create(user, host, port);
    }

    @Override
    public final int compareTo(UriAuthority that) {
        return this.toString().compareTo(that.toString());
    }

    public final boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof UriAuthority) {
            return this.toString().equals(((UriAuthority)other).toString());
        }
        return false;
    }

    public final int hashCode() {
        return Murmur3.seed((String)this.toString());
    }

    public <T> Output<T> debug(Output<T> output) {
        output = output.write("UriAuthority").write(46);
        output = this.isDefined() ? output.write("parse").write(40).write(34).display((Object)this).write(34) : output.write("undefined").write(40);
        output = output.write(41);
        return output;
    }

    public <T> Output<T> display(Output<T> output) {
        if (this.string != null) {
            output = output.write(this.string);
        } else {
            if (this.user.isDefined()) {
                output = output.display((Object)this.user).write(64);
            }
            output = output.display((Object)this.host);
            if (this.port.isDefined()) {
                output = output.write(58).display((Object)this.port);
            }
        }
        return output;
    }

    public final String toString() {
        if (this.string == null) {
            this.string = Format.display((Object)this);
        }
        return this.string;
    }

    public static UriAuthority undefined() {
        if (undefined == null) {
            undefined = new UriAuthority(UriUser.undefined(), UriHost.undefined(), UriPort.undefined());
        }
        return undefined;
    }

    public static UriAuthority create(UriUser user, UriHost host, UriPort port) {
        if (user == null) {
            user = UriUser.undefined();
        }
        if (host == null) {
            host = UriHost.undefined();
        }
        if (port == null) {
            port = UriPort.undefined();
        }
        if (user.isDefined() || host.isDefined() || port.isDefined()) {
            return new UriAuthority(user, host, port);
        }
        return UriAuthority.undefined();
    }

    public static UriAuthority create(UriHost host, UriPort port) {
        return UriAuthority.create(null, host, port);
    }

    public static UriAuthority create(UriHost host) {
        return UriAuthority.create(null, host, null);
    }

    public static UriAuthority parse(String string) {
        return Uri.standardParser().parseAuthorityString(string);
    }
}

