/*
 * Decompiled with CFR 0.152.
 */
package swim.uri;

import swim.codec.Debug;
import swim.codec.Display;
import swim.codec.Format;
import swim.codec.Output;
import swim.uri.Uri;
import swim.uri.UriPart;
import swim.util.HashGenCacheMap;
import swim.util.Murmur3;

public class UriFragment
extends UriPart
implements Comparable<UriFragment>,
Debug,
Display {
    protected final String identifier;
    String string;
    private static UriFragment undefined;
    private static ThreadLocal<HashGenCacheMap<String, UriFragment>> cache;

    protected UriFragment(String identifier) {
        this.identifier = identifier;
    }

    public final boolean isDefined() {
        return this.identifier != null;
    }

    public String identifier() {
        return this.identifier;
    }

    @Override
    public final int compareTo(UriFragment that) {
        return this.toString().compareTo(that.toString());
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof UriFragment) {
            UriFragment that = (UriFragment)other;
            return this.identifier == null ? that.identifier == null : this.identifier.equals(that.identifier);
        }
        return false;
    }

    public int hashCode() {
        return this.identifier == null ? 0 : Murmur3.seed((String)this.identifier);
    }

    public <T> Output<T> debug(Output<T> output) {
        output = output.write("UriFragment").write(46);
        output = this.isDefined() ? output.write("parse").write(40).write(34).display((Object)this).write(34) : output.write("undefined").write(40);
        output = output.write(41);
        return output;
    }

    public <T> Output<T> display(Output<T> output) {
        if (this.string != null) {
            output = output.write(this.string);
        } else if (this.identifier != null) {
            output = Uri.writeFragment(output, this.identifier);
        }
        return output;
    }

    public String toString() {
        if (this.string == null) {
            this.string = Format.display((Object)this);
        }
        return this.string;
    }

    public static UriFragment undefined() {
        if (undefined == null) {
            undefined = new UriFragment(null);
        }
        return undefined;
    }

    public static UriFragment create(String identifier) {
        if (identifier != null) {
            HashGenCacheMap<String, UriFragment> cache = UriFragment.cache();
            UriFragment fragment = (UriFragment)cache.get((Object)identifier);
            if (fragment != null) {
                return fragment;
            }
            return (UriFragment)cache.put((Object)identifier, (Object)new UriFragment(identifier));
        }
        return UriFragment.undefined();
    }

    public static UriFragment parse(String string) {
        return Uri.standardParser().parseFragmentString(string);
    }

    static HashGenCacheMap<String, UriFragment> cache() {
        HashGenCacheMap cache = UriFragment.cache.get();
        if (cache == null) {
            int cacheSize;
            try {
                cacheSize = Integer.parseInt(System.getProperty("swim.uri.fragment.cache.size"));
            }
            catch (NumberFormatException e) {
                cacheSize = 32;
            }
            cache = new HashGenCacheMap(cacheSize);
            UriFragment.cache.set((HashGenCacheMap<String, UriFragment>)cache);
        }
        return cache;
    }

    static {
        cache = new ThreadLocal();
    }
}

