/*
 * Decompiled with CFR 0.152.
 */
package swim.uri;

import swim.codec.Base10;
import swim.codec.Base16;
import swim.codec.Diagnostic;
import swim.codec.Input;
import swim.codec.Output;
import swim.codec.Parser;
import swim.codec.Utf8;
import swim.uri.Uri;
import swim.uri.UriHost;
import swim.uri.UriParser;

final class UriHostAddressParser
extends Parser<UriHost> {
    final UriParser uri;
    final Output<String> output;
    final int c1;
    final int x;
    final int step;

    UriHostAddressParser(UriParser uri, Output<String> output, int c1, int x, int step) {
        this.uri = uri;
        this.output = output;
        this.c1 = c1;
        this.x = x;
        this.step = step;
    }

    UriHostAddressParser(UriParser uri) {
        this(uri, null, 0, 0, 1);
    }

    public Parser<UriHost> feed(Input input) {
        return UriHostAddressParser.parse(input, this.uri, this.output, this.c1, this.x, this.step);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Parser<UriHost> parse(Input input, UriParser uri, Output<String> output, int c1, int x, int step) {
        block17: {
            int c = 0;
            if (output == null) {
                output = Utf8.decodedString();
            }
            while (step <= 4) {
                while (input.isCont() && Base10.isDigit((int)(c = input.head()))) {
                    input = input.step();
                    output = output.write(c);
                    x = 10 * x + Base10.decodeDigit((int)c);
                }
                if (input.isCont()) {
                    if (c == 46 && step < 4 && x <= 255) {
                        input = input.step();
                        output = output.write(c);
                        x = 0;
                        ++step;
                        continue;
                    }
                    if (!Uri.isHostChar(c) && c != 37 && step == 4 && x <= 255) {
                        return Parser.done((Object)uri.hostIPv4((String)output.bind()));
                    }
                    x = 0;
                    step = 5;
                    break;
                }
                if (input.isEmpty()) break;
                if (step != 4 || x > 255) return Parser.done((Object)uri.hostName((String)output.bind()));
                return Parser.done((Object)uri.hostIPv4((String)output.bind()));
            }
            while (true) {
                if (step == 5) {
                    while (input.isCont() && Uri.isHostChar(c = input.head())) {
                        input = input.step();
                        output = output.write(Character.toLowerCase(c));
                    }
                    if (input.isCont() && c == 37) {
                        input = input.step();
                        step = 6;
                    } else if (!input.isEmpty()) {
                        return Parser.done((Object)uri.hostName((String)output.bind()));
                    }
                }
                if (step == 6) {
                    if (input.isCont()) {
                        c = input.head();
                        if (!Base16.isDigit((int)c)) return Parser.error((Diagnostic)Diagnostic.expected((String)"hex digit", (Input)input));
                        input = input.step();
                        c1 = c;
                        step = 7;
                    } else if (input.isDone()) {
                        return Parser.error((Diagnostic)Diagnostic.expected((String)"hex digit", (Input)input));
                    }
                }
                if (step != 7) break block17;
                if (!input.isCont()) break;
                c = input.head();
                if (!Base16.isDigit((int)c)) return Parser.error((Diagnostic)Diagnostic.expected((String)"hex digit", (Input)input));
                input = input.step();
                output = output.write(Base16.decodeDigit((int)c1) << 4 | Base16.decodeDigit((int)c));
                c1 = 0;
                step = 5;
            }
            if (input.isDone()) {
                return Parser.error((Diagnostic)Diagnostic.expected((String)"hex digit", (Input)input));
            }
        }
        if (!input.isError()) return new UriHostAddressParser(uri, (Output<String>)output, c1, x, step);
        return Parser.error((Throwable)input.trap());
    }

    static Parser<UriHost> parse(Input input, UriParser uri) {
        return UriHostAddressParser.parse(input, uri, null, 0, 0, 1);
    }
}

