/*
 * Decompiled with CFR 0.152.
 */
package swim.uri;

import swim.codec.Input;
import swim.codec.Parser;
import swim.uri.UriHost;
import swim.uri.UriParser;

final class UriHostParser
extends Parser<UriHost> {
    final UriParser uri;

    UriHostParser(UriParser uri) {
        this.uri = uri;
    }

    public Parser<UriHost> feed(Input input) {
        return UriHostParser.parse(input, this.uri);
    }

    static Parser<UriHost> parse(Input input, UriParser uri) {
        if (input.isCont()) {
            int c = input.head();
            if (c == 91) {
                return uri.parseHostLiteral(input);
            }
            return uri.parseHostAddress(input);
        }
        if (input.isDone()) {
            return Parser.done((Object)uri.hostName(""));
        }
        if (input.isError()) {
            return Parser.error((Throwable)input.trap());
        }
        return new UriHostParser(uri);
    }
}

