/*
 * Decompiled with CFR 0.152.
 */
package swim.uri;

import swim.codec.Diagnostic;
import swim.codec.Input;
import swim.codec.Parser;
import swim.codec.Unicode;
import swim.uri.Uri;
import swim.uri.UriAbsoluteParser;
import swim.uri.UriAuthority;
import swim.uri.UriAuthorityParser;
import swim.uri.UriFragment;
import swim.uri.UriFragmentParser;
import swim.uri.UriHost;
import swim.uri.UriHostAddressParser;
import swim.uri.UriHostLiteralParser;
import swim.uri.UriHostParser;
import swim.uri.UriPath;
import swim.uri.UriPathBuilder;
import swim.uri.UriPathParser;
import swim.uri.UriPort;
import swim.uri.UriPortParser;
import swim.uri.UriQuery;
import swim.uri.UriQueryBuilder;
import swim.uri.UriQueryParser;
import swim.uri.UriScheme;
import swim.uri.UriSchemeParser;
import swim.uri.UriUser;
import swim.uri.UriUserParser;

public class UriParser {
    public Uri absolute(UriScheme scheme, UriAuthority authority, UriPath path, UriQuery query, UriFragment fragment) {
        return Uri.create(scheme, authority, path, query, fragment);
    }

    public UriScheme scheme(String name) {
        return UriScheme.create(name);
    }

    public UriAuthority authority(UriUser user, UriHost host, UriPort port) {
        return UriAuthority.create(user, host, port);
    }

    public UriUser user(String username, String password) {
        return UriUser.create(username, password);
    }

    public UriHost hostName(String address) {
        return UriHost.name(address);
    }

    public UriHost hostIPv4(String address) {
        return UriHost.ipv4(address);
    }

    public UriHost hostIPv6(String address) {
        return UriHost.ipv6(address);
    }

    public UriPort port(int number) {
        return UriPort.create(number);
    }

    public UriPath pathEmpty() {
        return UriPath.empty();
    }

    public UriPathBuilder pathBuilder() {
        return new UriPathBuilder();
    }

    public UriQueryBuilder queryBuilder() {
        return new UriQueryBuilder();
    }

    public UriFragment fragment(String identifier) {
        return UriFragment.create(identifier);
    }

    public Parser<Uri> absoluteParser() {
        return new UriAbsoluteParser(this);
    }

    public Parser<Uri> parseAbsolute(Input input) {
        return UriAbsoluteParser.parse(input, this);
    }

    public Uri parseAbsoluteString(String string) {
        Input input = Unicode.stringInput((String)string);
        Parser parser = this.parseAbsolute(input);
        if (input.isCont() && !parser.isError()) {
            parser = Parser.error((Diagnostic)Diagnostic.unexpected((Input)input));
        }
        return (Uri)parser.bind();
    }

    public Parser<UriScheme> schemeParser() {
        return new UriSchemeParser(this);
    }

    public Parser<UriScheme> parseScheme(Input input) {
        return UriSchemeParser.parse(input, this);
    }

    public UriScheme parseSchemeString(String string) {
        Input input = Unicode.stringInput((String)string);
        Parser parser = this.parseScheme(input);
        if (input.isCont() && parser.isError()) {
            parser = Parser.error((Diagnostic)Diagnostic.unexpected((Input)input));
        }
        return (UriScheme)parser.bind();
    }

    public Parser<UriAuthority> authorityParser() {
        return new UriAuthorityParser(this);
    }

    public Parser<UriAuthority> parseAuthority(Input input) {
        return UriAuthorityParser.parse(input, this);
    }

    public UriAuthority parseAuthorityString(String string) {
        Input input = Unicode.stringInput((String)string);
        Parser parser = this.parseAuthority(input);
        if (input.isCont() && !parser.isError()) {
            parser = Parser.error((Diagnostic)Diagnostic.unexpected((Input)input));
        }
        return (UriAuthority)parser.bind();
    }

    public Parser<UriUser> userParser() {
        return new UriUserParser(this);
    }

    public Parser<UriUser> parseUser(Input input) {
        return UriUserParser.parse(input, this);
    }

    public UriUser parseUserString(String string) {
        Input input = Unicode.stringInput((String)string);
        Parser parser = this.parseUser(input);
        if (input.isCont() && !parser.isError()) {
            parser = Parser.error((Diagnostic)Diagnostic.unexpected((Input)input));
        }
        return (UriUser)parser.bind();
    }

    public Parser<UriHost> hostParser() {
        return new UriHostParser(this);
    }

    public Parser<UriHost> parseHost(Input input) {
        return UriHostParser.parse(input, this);
    }

    public UriHost parseHostString(String string) {
        Input input = Unicode.stringInput((String)string);
        Parser parser = this.parseHost(input);
        if (input.isCont() && !parser.isError()) {
            parser = Parser.error((Diagnostic)Diagnostic.unexpected((Input)input));
        }
        return (UriHost)parser.bind();
    }

    public Parser<UriHost> hostAddressParser() {
        return new UriHostAddressParser(this);
    }

    public Parser<UriHost> parseHostAddress(Input input) {
        return UriHostAddressParser.parse(input, this);
    }

    public Parser<UriHost> hostLiteralParser() {
        return new UriHostLiteralParser(this);
    }

    public Parser<UriHost> parseHostLiteral(Input input) {
        return UriHostLiteralParser.parse(input, this);
    }

    public Parser<UriPort> portParser() {
        return new UriPortParser(this);
    }

    public Parser<UriPort> parsePort(Input input) {
        return UriPortParser.parse(input, this);
    }

    public UriPort parsePortString(String string) {
        Input input = Unicode.stringInput((String)string);
        Parser parser = this.parsePort(input);
        if (input.isCont() && !parser.isError()) {
            parser = Parser.error((Diagnostic)Diagnostic.unexpected((Input)input));
        }
        return (UriPort)parser.bind();
    }

    public Parser<UriPath> pathParser(UriPathBuilder builder) {
        return new UriPathParser(this, builder);
    }

    public Parser<UriPath> pathParser() {
        return new UriPathParser(this);
    }

    public Parser<UriPath> parsePath(Input input, UriPathBuilder builder) {
        return UriPathParser.parse(input, this, builder);
    }

    public Parser<UriPath> parsePath(Input input) {
        return UriPathParser.parse(input, this);
    }

    public UriPath parsePathString(String string) {
        Input input = Unicode.stringInput((String)string);
        Parser parser = this.parsePath(input);
        if (input.isCont() && !parser.isError()) {
            parser = Parser.error((Diagnostic)Diagnostic.unexpected((Input)input));
        }
        return (UriPath)parser.bind();
    }

    public Parser<UriQuery> queryParser(UriQueryBuilder builder) {
        return new UriQueryParser(this, builder);
    }

    public Parser<UriQuery> queryParser() {
        return new UriQueryParser(this);
    }

    public Parser<UriQuery> parseQuery(Input input, UriQueryBuilder builder) {
        return UriQueryParser.parse(input, this, builder);
    }

    public Parser<UriQuery> parseQuery(Input input) {
        return UriQueryParser.parse(input, this);
    }

    public UriQuery parseQueryString(String string) {
        Input input = Unicode.stringInput((String)string);
        Parser parser = this.parseQuery(input);
        if (input.isCont() && !parser.isError()) {
            parser = Parser.error((Diagnostic)Diagnostic.unexpected((Input)input));
        }
        return (UriQuery)parser.bind();
    }

    public Parser<UriFragment> fragmentParser() {
        return new UriFragmentParser(this);
    }

    public Parser<UriFragment> parseFragment(Input input) {
        return UriFragmentParser.parse(input, this);
    }

    public UriFragment parseFragmentString(String string) {
        Input input = Unicode.stringInput((String)string);
        Parser parser = this.parseFragment(input);
        if (input.isCont() && !parser.isError()) {
            parser = Parser.error((Diagnostic)Diagnostic.unexpected((Input)input));
        }
        return (UriFragment)parser.bind();
    }
}

