/*
 * Decompiled with CFR 0.152.
 */
package swim.uri;

import java.util.Iterator;
import java.util.Map;
import swim.collections.HashTrieMap;
import swim.uri.Uri;
import swim.uri.UriFragment;
import swim.uri.UriMapper;
import swim.uri.UriPart;
import swim.uri.UriPath;
import swim.uri.UriPathMapper;
import swim.uri.UriPathMappingChildIterator;
import swim.uri.UriPathMappingEntryIterator;
import swim.uri.UriPathMappingIterator;
import swim.uri.UriPathMappingKeyIterator;
import swim.uri.UriPathMappingValueIterator;
import swim.uri.UriQuery;
import swim.uri.UriQueryMapper;
import swim.util.Murmur3;

final class UriPathMapping<T>
extends UriPathMapper<T> {
    final HashTrieMap<String, UriPathMapper<T>> table;
    final UriPathMapper<T> wildcard;
    final UriQueryMapper<T> terminal;
    private static int hashSeed;

    UriPathMapping(HashTrieMap<String, UriPathMapper<T>> table, UriPathMapper<T> wildcard, UriQueryMapper<T> terminal) {
        this.table = table;
        this.wildcard = wildcard;
        this.terminal = terminal;
    }

    @Override
    public boolean isEmpty() {
        return this.table.isEmpty() && this.wildcard.isEmpty() && this.terminal.isEmpty();
    }

    @Override
    public int size() {
        int size = 0;
        Iterator routes = this.table.valueIterator();
        while (routes.hasNext()) {
            size += ((UriPathMapper)routes.next()).size();
        }
        size += this.wildcard.size();
        return size += this.terminal.size();
    }

    @Override
    public boolean containsValue(Object value) {
        Iterator routes = this.table.valueIterator();
        while (routes.hasNext()) {
            if (!((UriPathMapper)routes.next()).containsValue(value)) continue;
            return true;
        }
        return this.wildcard.containsValue(value) || this.terminal.containsValue(value);
    }

    @Override
    UriMapper<T> getSuffix(UriPath path, UriQuery query, UriFragment fragment) {
        if (!path.isEmpty()) {
            UriPathMapper<T> mapping = (UriPathMapper<T>)this.table.get((Object)path.head());
            if (mapping == null) {
                mapping = this.wildcard;
            }
            return mapping.getSuffix(path.tail(), query, fragment);
        }
        return this;
    }

    @Override
    T get(UriPath path, UriQuery query, UriFragment fragment) {
        if (!path.isEmpty()) {
            UriPathMapper<T> mapping = (UriPathMapper<T>)this.table.get((Object)path.head());
            if (mapping == null) {
                mapping = this.wildcard;
            }
            return mapping.get(path.tail(), query, fragment);
        }
        return this.terminal.get(query, fragment);
    }

    @Override
    UriPathMapping<T> merged(UriPathMapping<T> that) {
        HashTrieMap table = this.table;
        for (Map.Entry route : that.table) {
            String segment = (String)route.getKey();
            UriPathMapper mapping = (UriPathMapper)table.get((Object)segment);
            mapping = mapping != null ? mapping.merged((UriPathMapper)route.getValue()) : (UriPathMapper)route.getValue();
            table = table.updated((Object)segment, mapping);
        }
        UriPathMapper<T> wildcard = this.wildcard.merged(that.wildcard);
        UriQueryMapper<T> terminal = this.terminal.merged(that.terminal);
        return new UriPathMapping<T>(table, wildcard, terminal);
    }

    @Override
    UriPathMapper<T> merged(UriPathMapper<T> that) {
        if (that instanceof UriPathMapping) {
            return this.merged((UriPathMapping)that);
        }
        return that;
    }

    @Override
    UriPathMapper<T> removed(UriPath path, UriQuery query, UriFragment fragment) {
        if (!path.isEmpty()) {
            String segment = path.head();
            if (!segment.isEmpty() && segment.charAt(0) == ':') {
                UriPathMapper<T> newWildcard;
                UriPathMapper<T> oldWildcard = this.wildcard;
                if (oldWildcard != null && oldWildcard != (newWildcard = oldWildcard.removed(path.tail(), query, fragment))) {
                    if (!(this.table.isEmpty() && newWildcard.isEmpty() && this.terminal.isEmpty())) {
                        return new UriPathMapping<T>(this.table, newWildcard, this.terminal);
                    }
                    return (UriPathMapper)UriPathMapping.empty();
                }
            } else {
                UriPathMapper newMapping;
                HashTrieMap<String, UriPathMapper<T>> oldTable = this.table;
                UriPathMapper oldMapping = (UriPathMapper)oldTable.get((Object)segment);
                if (oldMapping != null && oldMapping != (newMapping = oldMapping.removed(path.tail(), query, fragment))) {
                    HashTrieMap newTable = !newMapping.isEmpty() ? oldTable.updated((Object)segment, newMapping) : oldTable.removed((Object)segment);
                    if (!(newTable.isEmpty() && this.wildcard.isEmpty() && this.terminal.isEmpty())) {
                        return new UriPathMapping<T>(newTable, this.wildcard, this.terminal);
                    }
                    return (UriPathMapper)UriPathMapping.empty();
                }
            }
        } else {
            UriQueryMapper<T> newTerminal;
            UriQueryMapper<T> oldTerminal = this.terminal;
            if (oldTerminal != null && oldTerminal != (newTerminal = oldTerminal.removed(query, fragment))) {
                if (!(this.table.isEmpty() && this.wildcard.isEmpty() && newTerminal.isEmpty())) {
                    return new UriPathMapping<T>(this.table, this.wildcard, newTerminal);
                }
                return (UriPathMapper)UriPathMapping.empty();
            }
        }
        return this;
    }

    @Override
    UriPathMapper<T> unmerged(UriPathMapping<T> that) {
        HashTrieMap table = this.table;
        for (Map.Entry route : that.table) {
            String segment = (String)route.getKey();
            UriPathMapper mapping = (UriPathMapper)this.table.get((Object)segment);
            if (mapping == null) continue;
            if (!(mapping = mapping.unmerged((UriPathMapper)route.getValue())).isEmpty()) {
                table = table.updated((Object)segment, mapping);
                continue;
            }
            table = table.removed((Object)segment);
        }
        UriPathMapper<T> wildcard = this.wildcard.unmerged(that.wildcard);
        UriQueryMapper<T> terminal = this.terminal.unmerged(that.terminal);
        if (!(table.isEmpty() && wildcard.isEmpty() && terminal.isEmpty())) {
            return new UriPathMapping<T>(table, wildcard, terminal);
        }
        return (UriPathMapper)UriPathMapping.empty();
    }

    @Override
    UriPathMapper<T> unmerged(UriPathMapper<T> that) {
        if (that instanceof UriPathMapping) {
            return this.unmerged((UriPathMapping)that);
        }
        return this;
    }

    @Override
    public Iterator<Map.Entry<Uri, T>> iterator() {
        UriPathMappingEntryIterator tableIterator = new UriPathMappingEntryIterator(this.table.valueIterator());
        return new UriPathMappingIterator(tableIterator, this.wildcard.iterator(), this.terminal.iterator());
    }

    @Override
    public Iterator<Uri> keyIterator() {
        UriPathMappingKeyIterator tableIterator = new UriPathMappingKeyIterator(this.table.valueIterator());
        return new UriPathMappingIterator<Uri>(tableIterator, this.wildcard.keyIterator(), this.terminal.keyIterator());
    }

    @Override
    public Iterator<T> valueIterator() {
        UriPathMappingValueIterator tableIterator = new UriPathMappingValueIterator(this.table.valueIterator());
        return new UriPathMappingIterator(tableIterator, this.wildcard.valueIterator(), this.terminal.valueIterator());
    }

    @Override
    public long childCount() {
        return this.table.size();
    }

    @Override
    public Iterator<UriPart> childIterator() {
        return new UriPathMappingChildIterator(this.table.keyIterator());
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof UriPathMapping) {
            UriPathMapping that = (UriPathMapping)other;
            return this.table.equals(that.table) && this.wildcard.equals(that.wildcard) && this.terminal.equals(that.terminal);
        }
        return false;
    }

    @Override
    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(UriPathMapping.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)this.table.hashCode()), (int)this.wildcard.hashCode()), (int)this.terminal.hashCode()));
    }
}

