/*
 * Decompiled with CFR 0.152.
 */
package swim.uri;

import swim.codec.Format;
import swim.codec.Output;
import swim.uri.UriPath;

final class UriPathSlash
extends UriPath {
    UriPath tail;
    String string;

    UriPathSlash(UriPath tail) {
        this.tail = tail;
    }

    @Override
    public boolean isDefined() {
        return true;
    }

    @Override
    public boolean isAbsolute() {
        return true;
    }

    @Override
    public boolean isRelative() {
        return false;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public String head() {
        return "/";
    }

    @Override
    public UriPath tail() {
        return this.tail;
    }

    @Override
    void setTail(UriPath tail) {
        this.tail = tail;
    }

    @Override
    UriPath dealias() {
        return new UriPathSlash(this.tail);
    }

    @Override
    public UriPath parent() {
        UriPath tail = this.tail;
        if (tail.isEmpty()) {
            return UriPath.empty();
        }
        UriPath next = tail.tail();
        if (next.isEmpty()) {
            return UriPath.slash();
        }
        return new UriPathSlash(tail.parent());
    }

    @Override
    public UriPath base() {
        UriPath tail = this.tail;
        if (tail.isEmpty()) {
            return this;
        }
        return new UriPathSlash(tail.base());
    }

    @Override
    public UriPath body() {
        UriPath tail = this.tail;
        if (tail.isEmpty()) {
            return UriPath.empty();
        }
        UriPath next = tail.tail();
        if (next.isEmpty()) {
            return UriPath.slash();
        }
        return new UriPathSlash(tail.body());
    }

    @Override
    public UriPath prependedSegment(String segment) {
        return UriPath.segment(segment, this);
    }

    @Override
    public UriPath merge(UriPath that) {
        if (that == null) {
            throw new NullPointerException();
        }
        return UriPath.merge(this, that);
    }

    @Override
    public <T> Output<T> debug(Output<T> output) {
        output = output.write("UriPath").write(46).write("parse").write(40).write(34).display((Object)this).write(34).write(41);
        return output;
    }

    @Override
    public <T> Output<T> display(Output<T> output) {
        output = this.string != null ? output.write(this.string) : UriPath.display(output, this);
        return output;
    }

    @Override
    public String toString() {
        if (this.string == null) {
            this.string = Format.display((Object)this);
        }
        return this.string;
    }
}

