/*
 * Decompiled with CFR 0.152.
 */
package swim.uri;

import swim.codec.Debug;
import swim.codec.Display;
import swim.codec.Format;
import swim.codec.Output;
import swim.uri.Uri;
import swim.util.HashGenCacheSet;
import swim.util.Murmur3;

public class UriPort
implements Comparable<UriPort>,
Debug,
Display {
    protected final int number;
    private static int hashSeed;
    private static UriPort undefined;
    private static ThreadLocal<HashGenCacheSet<UriPort>> cache;

    protected UriPort(int number) {
        this.number = number;
    }

    public final boolean isDefined() {
        return this.number != 0;
    }

    public final int number() {
        return this.number;
    }

    @Override
    public int compareTo(UriPort that) {
        return Integer.compare(this.number, that.number);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof UriPort) {
            return this.number == ((UriPort)other).number;
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(UriPort.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)hashSeed, (int)this.number));
    }

    public <T> Output<T> debug(Output<T> output) {
        output = output.write("UriPort").write(46);
        if (this.isDefined()) {
            output = output.write("create").write(40);
            output = Format.displayInt((Output)output, (int)this.number);
            output = output.write(41);
        } else {
            output = output.write("undefined").write(40).write(41);
        }
        return output;
    }

    public <T> Output<T> display(Output<T> output) {
        return Format.displayInt(output, (int)this.number);
    }

    public String toString() {
        return Integer.toString(this.number);
    }

    public static UriPort undefined() {
        if (undefined == null) {
            undefined = new UriPort(0);
        }
        return undefined;
    }

    public static UriPort create(int number) {
        if (number > 0) {
            return (UriPort)UriPort.cache().put((Object)new UriPort(number));
        }
        if (number == 0) {
            return UriPort.undefined();
        }
        throw new IllegalArgumentException(Integer.toString(number));
    }

    public static UriPort parse(String string) {
        return Uri.standardParser().parsePortString(string);
    }

    static HashGenCacheSet<UriPort> cache() {
        HashGenCacheSet cache = UriPort.cache.get();
        if (cache == null) {
            int cacheSize;
            try {
                cacheSize = Integer.parseInt(System.getProperty("swim.uri.port.cache.size"));
            }
            catch (NumberFormatException e) {
                cacheSize = 16;
            }
            cache = new HashGenCacheSet(cacheSize);
            UriPort.cache.set((HashGenCacheSet<UriPort>)cache);
        }
        return cache;
    }

    static {
        cache = new ThreadLocal();
    }
}

