/*
 * Decompiled with CFR 0.152.
 */
package swim.uri;

import swim.codec.Base10;
import swim.codec.Diagnostic;
import swim.codec.Input;
import swim.codec.Parser;
import swim.uri.UriParser;
import swim.uri.UriPort;

final class UriPortParser
extends Parser<UriPort> {
    final UriParser uri;
    final int number;

    UriPortParser(UriParser uri, int number) {
        this.uri = uri;
        this.number = number;
    }

    UriPortParser(UriParser uri) {
        this(uri, 0);
    }

    public Parser<UriPort> feed(Input input) {
        return UriPortParser.parse(input, this.uri, this.number);
    }

    static Parser<UriPort> parse(Input input, UriParser uri, int number) {
        int c = 0;
        while (input.isCont() && Base10.isDigit((int)(c = input.head()))) {
            input = input.step();
            if ((number = 10 * number + Base10.decodeDigit((int)c)) >= 0) continue;
            return Parser.error((Diagnostic)Diagnostic.message((String)"port overflow", (Input)input));
        }
        if (!input.isEmpty()) {
            return Parser.done((Object)uri.port(number));
        }
        return new UriPortParser(uri, number);
    }

    static Parser<UriPort> parse(Input input, UriParser uri) {
        return UriPortParser.parse(input, uri, 0);
    }
}

