/*
 * Decompiled with CFR 0.152.
 */
package swim.uri;

import swim.codec.Debug;
import swim.codec.Display;
import swim.codec.Output;
import swim.uri.Uri;
import swim.uri.UriPart;
import swim.util.HashGenCacheMap;
import swim.util.Murmur3;

public class UriScheme
extends UriPart
implements Comparable<UriScheme>,
Debug,
Display {
    protected final String name;
    private static UriScheme undefined;
    private static ThreadLocal<HashGenCacheMap<String, UriScheme>> cache;

    protected UriScheme(String name) {
        this.name = name;
    }

    public final boolean isDefined() {
        return this.name.length() > 0;
    }

    public final String name() {
        return this.name;
    }

    @Override
    public final int compareTo(UriScheme that) {
        return this.name.compareTo(that.name);
    }

    public final boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof UriScheme) {
            return this.name.equals(((UriScheme)other).name);
        }
        return false;
    }

    public final int hashCode() {
        return Murmur3.seed((String)this.name);
    }

    public <T> Output<T> debug(Output<T> output) {
        output = output.write("UriScheme").write(46);
        output = this.isDefined() ? output.write("parse").write(40).write(34).display((Object)this).write(34) : output.write("undefined").write(40);
        output = output.write(41);
        return output;
    }

    public <T> Output<T> display(Output<T> output) {
        return Uri.writeScheme(output, this.name);
    }

    public final String toString() {
        return this.name;
    }

    public static UriScheme undefined() {
        if (undefined == null) {
            undefined = new UriScheme("");
        }
        return undefined;
    }

    public static UriScheme create(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        HashGenCacheMap<String, UriScheme> cache = UriScheme.cache();
        UriScheme scheme = (UriScheme)cache.get((Object)name);
        if (scheme != null) {
            return scheme;
        }
        return (UriScheme)cache.put((Object)name, (Object)new UriScheme(name));
    }

    public static UriScheme parse(String string) {
        return Uri.standardParser().parseSchemeString(string);
    }

    static HashGenCacheMap<String, UriScheme> cache() {
        HashGenCacheMap cache = UriScheme.cache.get();
        if (cache == null) {
            int cacheSize;
            try {
                cacheSize = Integer.parseInt(System.getProperty("swim.uri.scheme.cache.size"));
            }
            catch (NumberFormatException e) {
                cacheSize = 4;
            }
            cache = new HashGenCacheMap(cacheSize);
            UriScheme.cache.set((HashGenCacheMap<String, UriScheme>)cache);
        }
        return cache;
    }

    static {
        cache = new ThreadLocal();
    }
}

