/*
 * Decompiled with CFR 0.152.
 */
package swim.uri;

import swim.collections.HashTrieMap;
import swim.uri.Uri;
import swim.uri.UriAuthority;
import swim.uri.UriAuthorityMapper;
import swim.uri.UriFragment;
import swim.uri.UriMapper;
import swim.uri.UriPath;
import swim.uri.UriQuery;
import swim.uri.UriScheme;
import swim.uri.UriSchemeMapping;

abstract class UriSchemeMapper<T>
extends UriMapper<T> {
    UriSchemeMapper() {
    }

    abstract UriMapper<T> getSuffix(UriScheme var1, UriAuthority var2, UriPath var3, UriQuery var4, UriFragment var5);

    @Override
    public UriMapper<T> getSuffix(Uri uri) {
        return this.getSuffix(uri.scheme(), uri.authority(), uri.path(), uri.query(), uri.fragment());
    }

    abstract T get(UriScheme var1, UriAuthority var2, UriPath var3, UriQuery var4, UriFragment var5);

    @Override
    public T get(Uri uri) {
        return this.get(uri.scheme(), uri.authority(), uri.path(), uri.query(), uri.fragment());
    }

    @Override
    abstract UriSchemeMapper<T> merged(UriSchemeMapper<T> var1);

    @Override
    public UriMapper<T> merged(UriMapper<T> that) {
        if (that instanceof UriSchemeMapper) {
            return this.merged((UriSchemeMapper)that);
        }
        return that;
    }

    abstract UriSchemeMapper<T> removed(UriScheme var1, UriAuthority var2, UriPath var3, UriQuery var4, UriFragment var5);

    @Override
    public UriMapper<T> removed(Uri pattern) {
        return this.removed(pattern.scheme(), pattern.authority(), pattern.path(), pattern.query(), pattern.fragment());
    }

    @Override
    abstract UriSchemeMapper<T> unmerged(UriSchemeMapper<T> var1);

    @Override
    public UriMapper<T> unmerged(UriMapper<T> that) {
        if (that instanceof UriSchemeMapper) {
            return this.unmerged((UriSchemeMapper)that);
        }
        return this;
    }

    static <T> UriSchemeMapper<T> compile(Uri pattern, UriScheme scheme, UriAuthority authority, UriPath path, UriQuery query, UriFragment fragment, T value) {
        if (scheme.isDefined()) {
            return new UriSchemeMapping(HashTrieMap.empty().updated((Object)scheme.name(), UriAuthorityMapper.compile(pattern, authority, path, query, fragment, value)));
        }
        return UriAuthorityMapper.compile(pattern, authority, path, query, fragment, value);
    }
}

