/*
 * Decompiled with CFR 0.152.
 */
package swim.uri;

import java.util.Iterator;
import java.util.Map;
import swim.collections.HashTrieMap;
import swim.uri.Uri;
import swim.uri.UriAuthority;
import swim.uri.UriAuthorityMapper;
import swim.uri.UriFragment;
import swim.uri.UriMapper;
import swim.uri.UriPath;
import swim.uri.UriQuery;
import swim.uri.UriScheme;
import swim.uri.UriSchemeMapper;
import swim.uri.UriSchemeMappingIterator;
import swim.uri.UriSchemeMappingKeyIterator;
import swim.uri.UriSchemeMappingValueIterator;
import swim.util.Murmur3;

final class UriSchemeMapping<T>
extends UriSchemeMapper<T> {
    final HashTrieMap<String, UriAuthorityMapper<T>> table;
    private static int hashSeed;

    UriSchemeMapping(HashTrieMap<String, UriAuthorityMapper<T>> table) {
        this.table = table;
    }

    @Override
    public boolean isEmpty() {
        return this.table.isEmpty();
    }

    @Override
    public int size() {
        int size = 0;
        Iterator routes = this.table.valueIterator();
        while (routes.hasNext()) {
            size += ((UriAuthorityMapper)routes.next()).size();
        }
        return size;
    }

    @Override
    public boolean containsValue(Object value) {
        Iterator routes = this.table.valueIterator();
        while (routes.hasNext()) {
            if (!((UriAuthorityMapper)routes.next()).containsValue(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    UriMapper<T> getSuffix(UriScheme scheme, UriAuthority authority, UriPath path, UriQuery query, UriFragment fragment) {
        UriAuthorityMapper mapping = (UriAuthorityMapper)this.table.get((Object)scheme.name());
        if (mapping != null) {
            return mapping.getSuffix(authority, path, query, fragment);
        }
        return UriMapper.empty();
    }

    @Override
    T get(UriScheme scheme, UriAuthority authority, UriPath path, UriQuery query, UriFragment fragment) {
        UriAuthorityMapper mapping = (UriAuthorityMapper)this.table.get((Object)scheme.name());
        if (mapping != null) {
            return mapping.get(authority, path, query, fragment);
        }
        return null;
    }

    @Override
    UriSchemeMapping<T> merged(UriSchemeMapping<T> that) {
        HashTrieMap table = this.table;
        for (Map.Entry route : that.table) {
            String schemeName = (String)route.getKey();
            UriAuthorityMapper mapping = (UriAuthorityMapper)this.table.get((Object)schemeName);
            mapping = mapping != null ? mapping.merged((UriAuthorityMapper)route.getValue()) : (UriAuthorityMapper)route.getValue();
            table = table.updated((Object)schemeName, mapping);
        }
        return new UriSchemeMapping<T>(table);
    }

    @Override
    UriSchemeMapper<T> merged(UriSchemeMapper<T> that) {
        if (that instanceof UriSchemeMapping) {
            return this.merged((UriSchemeMapping)that);
        }
        return that;
    }

    @Override
    UriSchemeMapper<T> removed(UriScheme scheme, UriAuthority authority, UriPath path, UriQuery query, UriFragment fragment) {
        UriAuthorityMapper newMapping;
        String schemeName = scheme.name();
        UriAuthorityMapper oldMapping = (UriAuthorityMapper)this.table.get((Object)schemeName);
        if (oldMapping != null && oldMapping != (newMapping = oldMapping.removed(authority, path, query, fragment))) {
            if (!oldMapping.isEmpty()) {
                return new UriSchemeMapping<T>(this.table.updated((Object)schemeName, newMapping));
            }
            return (UriSchemeMapper)UriSchemeMapping.empty();
        }
        return this;
    }

    @Override
    UriSchemeMapper<T> unmerged(UriSchemeMapping<T> that) {
        HashTrieMap table = this.table;
        for (Map.Entry route : that.table) {
            String schemeName = (String)route.getKey();
            UriAuthorityMapper mapping = (UriAuthorityMapper)table.get((Object)schemeName);
            if (mapping == null) continue;
            if (!(mapping = mapping.unmerged((UriAuthorityMapper)route.getValue())).isEmpty()) {
                table = table.updated((Object)schemeName, mapping);
                continue;
            }
            table = table.removed((Object)schemeName);
        }
        if (!table.isEmpty()) {
            return new UriSchemeMapping<T>(table);
        }
        return (UriSchemeMapper)UriSchemeMapping.empty();
    }

    @Override
    UriSchemeMapper<T> unmerged(UriSchemeMapper<T> that) {
        if (that instanceof UriSchemeMapping) {
            return this.unmerged((UriSchemeMapping)that);
        }
        return this;
    }

    @Override
    public Iterator<Map.Entry<Uri, T>> iterator() {
        return new UriSchemeMappingIterator(this.table.valueIterator());
    }

    @Override
    public Iterator<Uri> keyIterator() {
        return new UriSchemeMappingKeyIterator(this.table.valueIterator());
    }

    @Override
    public Iterator<T> valueIterator() {
        return new UriSchemeMappingValueIterator(this.table.valueIterator());
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof UriSchemeMapping) {
            UriSchemeMapping that = (UriSchemeMapping)other;
            return this.table.equals(that.table);
        }
        return false;
    }

    @Override
    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(UriSchemeMapping.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)hashSeed, (int)this.table.hashCode()));
    }
}

