/*
 * Decompiled with CFR 0.152.
 */
package swim.uri;

import swim.codec.Diagnostic;
import swim.codec.Input;
import swim.codec.Output;
import swim.codec.Parser;
import swim.codec.Utf8;
import swim.uri.Uri;
import swim.uri.UriParser;
import swim.uri.UriScheme;

final class UriSchemeParser
extends Parser<UriScheme> {
    final UriParser uri;
    final Output<String> output;
    final int step;

    UriSchemeParser(UriParser uri, Output<String> output, int step) {
        this.uri = uri;
        this.output = output;
        this.step = step;
    }

    UriSchemeParser(UriParser uri) {
        this(uri, null, 1);
    }

    public Parser<UriScheme> feed(Input input) {
        return UriSchemeParser.parse(input, this.uri, this.output, this.step);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Parser<UriScheme> parse(Input input, UriParser uri, Output<String> output, int step) {
        int c = 0;
        if (step == 1) {
            if (input.isCont()) {
                c = input.head();
                if (!Uri.isAlpha(c)) return Parser.error((Diagnostic)Diagnostic.expected((String)"scheme", (Input)input));
                input = input.step();
                if (output == null) {
                    output = Utf8.decodedString();
                }
                output = output.write(Character.toLowerCase(c));
                step = 2;
            } else if (input.isDone()) {
                return Parser.error((Diagnostic)Diagnostic.expected((String)"scheme", (Input)input));
            }
        }
        if (step != 2) return new UriSchemeParser(uri, (Output<String>)output, step);
        while (input.isCont() && Uri.isSchemeChar(c = input.head())) {
            input = input.step();
            output = output.write(Character.toLowerCase(c));
        }
        if (input.isEmpty()) return new UriSchemeParser(uri, (Output<String>)output, step);
        return Parser.done((Object)uri.scheme((String)output.bind()));
    }

    static Parser<UriScheme> parse(Input input, UriParser uri) {
        return UriSchemeParser.parse(input, uri, null, 1);
    }
}

