/*
 * Decompiled with CFR 0.152.
 */
package swim.util;

import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceArray;
import swim.util.HashGenSetBucket;

public class HashGenSet<V> {
    static final AtomicIntegerFieldUpdater<HashGenSetBucket<?>> BUCKET_GEN4_WEIGHT = AtomicIntegerFieldUpdater.newUpdater(HashGenSetBucket.class, "gen4Weight");
    static final AtomicIntegerFieldUpdater<HashGenSetBucket<?>> BUCKET_GEN3_WEIGHT = AtomicIntegerFieldUpdater.newUpdater(HashGenSetBucket.class, "gen3Weight");
    static final AtomicIntegerFieldUpdater<HashGenSetBucket<?>> BUCKET_GEN2_WEIGHT = AtomicIntegerFieldUpdater.newUpdater(HashGenSetBucket.class, "gen2Weight");
    static final AtomicIntegerFieldUpdater<HashGenSetBucket<?>> BUCKET_GEN1_WEIGHT = AtomicIntegerFieldUpdater.newUpdater(HashGenSetBucket.class, "gen1Weight");
    static final AtomicIntegerFieldUpdater<HashGenSet<?>> GEN4_HITS = AtomicIntegerFieldUpdater.newUpdater(HashGenSet.class, "gen4Hits");
    static final AtomicIntegerFieldUpdater<HashGenSet<?>> GEN3_HITS = AtomicIntegerFieldUpdater.newUpdater(HashGenSet.class, "gen3Hits");
    static final AtomicIntegerFieldUpdater<HashGenSet<?>> GEN2_HITS = AtomicIntegerFieldUpdater.newUpdater(HashGenSet.class, "gen2Hits");
    static final AtomicIntegerFieldUpdater<HashGenSet<?>> GEN1_HITS = AtomicIntegerFieldUpdater.newUpdater(HashGenSet.class, "gen1Hits");
    static final AtomicIntegerFieldUpdater<HashGenSet<?>> MISSES = AtomicIntegerFieldUpdater.newUpdater(HashGenSet.class, "misses");
    static final AtomicIntegerFieldUpdater<HashGenSet<?>> EVICTS = AtomicIntegerFieldUpdater.newUpdater(HashGenSet.class, "evicts");
    final AtomicReferenceArray<HashGenSetBucket<V>> buckets;
    volatile int gen4Hits;
    volatile int gen3Hits;
    volatile int gen2Hits;
    volatile int gen1Hits;
    volatile int misses;
    volatile int evicts;

    public HashGenSet(int size) {
        this.buckets = new AtomicReferenceArray(size);
    }

    protected void evict(V value) {
    }

    public V put(V value) {
        V cacheVal;
        HashGenSetBucket<V> newBucket;
        HashGenSetBucket<V> bucket;
        if (this.buckets.length() == 0) {
            return value;
        }
        V evictVal = null;
        int index = Math.abs(value.hashCode()) % this.buckets.length();
        do {
            if ((bucket = this.buckets.get(index)) == null) {
                newBucket = new HashGenSetBucket<V>(value);
                cacheVal = value;
                continue;
            }
            if (bucket.gen4Val != null && value.equals(bucket.gen4Val)) {
                GEN4_HITS.incrementAndGet(this);
                BUCKET_GEN4_WEIGHT.incrementAndGet(bucket);
                newBucket = bucket;
                cacheVal = bucket.gen4Val;
                continue;
            }
            if (bucket.gen3Val != null && value.equals(bucket.gen3Val)) {
                GEN3_HITS.incrementAndGet(this);
                newBucket = BUCKET_GEN3_WEIGHT.incrementAndGet(bucket) > bucket.gen4Weight ? new HashGenSetBucket(bucket.gen3Val, bucket.gen3Weight, bucket.gen4Val, bucket.gen4Weight, bucket.gen2Val, bucket.gen2Weight, bucket.gen1Val, bucket.gen1Weight) : bucket;
                cacheVal = bucket.gen3Val;
                continue;
            }
            if (bucket.gen2Val != null && value.equals(bucket.gen2Val)) {
                GEN2_HITS.incrementAndGet(this);
                newBucket = BUCKET_GEN2_WEIGHT.incrementAndGet(bucket) > bucket.gen3Weight ? new HashGenSetBucket(bucket.gen4Val, bucket.gen4Weight, bucket.gen2Val, bucket.gen2Weight, bucket.gen3Val, bucket.gen3Weight, bucket.gen1Val, bucket.gen1Weight) : bucket;
                cacheVal = bucket.gen2Val;
                continue;
            }
            if (bucket.gen1Val != null && value.equals(bucket.gen1Val)) {
                GEN1_HITS.incrementAndGet(this);
                newBucket = BUCKET_GEN1_WEIGHT.incrementAndGet(bucket) > bucket.gen2Weight ? new HashGenSetBucket(bucket.gen4Val, bucket.gen4Weight, bucket.gen3Val, bucket.gen3Weight, bucket.gen1Val, bucket.gen1Weight, bucket.gen2Val, bucket.gen2Weight) : bucket;
                cacheVal = bucket.gen1Val;
                continue;
            }
            MISSES.incrementAndGet(this);
            evictVal = bucket.gen2Val;
            newBucket = new HashGenSetBucket(bucket.gen4Val, bucket.gen4Weight - 1, bucket.gen3Val, bucket.gen3Weight - 1, bucket.gen1Val, bucket.gen1Weight, value, 1);
            cacheVal = value;
        } while (bucket != newBucket && !this.buckets.compareAndSet(index, bucket, newBucket));
        if (evictVal != null) {
            EVICTS.incrementAndGet(this);
            this.evict(evictVal);
        }
        return cacheVal;
    }

    public boolean remove(V value) {
        boolean removed;
        HashGenSetBucket<Object> newBucket;
        HashGenSetBucket<V> bucket;
        if (this.buckets.length() == 0) {
            return false;
        }
        int index = Math.abs(value.hashCode()) % this.buckets.length();
        do {
            if ((bucket = this.buckets.get(index)) == null) {
                newBucket = null;
                removed = false;
                continue;
            }
            if (bucket.gen4Val != null && value.equals(bucket.gen4Val)) {
                newBucket = new HashGenSetBucket<Object>(bucket.gen3Val, bucket.gen3Weight, bucket.gen2Val, bucket.gen2Weight, bucket.gen1Val, bucket.gen1Weight, null, 0);
                removed = true;
                continue;
            }
            if (bucket.gen3Val != null && value.equals(bucket.gen3Val)) {
                newBucket = new HashGenSetBucket<Object>(bucket.gen4Val, bucket.gen4Weight, bucket.gen2Val, bucket.gen2Weight, bucket.gen1Val, bucket.gen1Weight, null, 0);
                removed = true;
                continue;
            }
            if (bucket.gen2Val != null && value.equals(bucket.gen2Val)) {
                newBucket = new HashGenSetBucket<Object>(bucket.gen4Val, bucket.gen4Weight, bucket.gen3Val, bucket.gen3Weight, bucket.gen1Val, bucket.gen1Weight, null, 0);
                removed = true;
                continue;
            }
            if (bucket.gen1Val != null && value.equals(bucket.gen1Val)) {
                newBucket = new HashGenSetBucket<Object>(bucket.gen4Val, bucket.gen4Weight, bucket.gen3Val, bucket.gen3Weight, bucket.gen2Val, bucket.gen2Weight, null, 0);
                removed = true;
                continue;
            }
            newBucket = bucket;
            removed = false;
        } while (bucket != newBucket && !this.buckets.compareAndSet(index, bucket, newBucket));
        return removed;
    }

    public void clear() {
        for (int i = 0; i < this.buckets.length(); ++i) {
            this.buckets.set(i, null);
        }
    }

    public double hitRatio() {
        double hits = (double)this.gen4Hits + (double)this.gen3Hits + (double)this.gen2Hits + (double)this.gen1Hits;
        return hits / (hits + (double)this.misses);
    }
}

