/*
 * Decompiled with CFR 0.152.
 */
package swim.util;

import java.util.Comparator;
import java.util.Map;
import java.util.NoSuchElementException;
import swim.util.OrderedMap;
import swim.util.OrderedMapCursor;

final class OrderedMapViewCursor<K, V>
implements OrderedMapCursor<K, V> {
    final OrderedMap<K, V> map;
    final OrderedMapCursor<K, V> cursor;
    final K fromKey;
    final K toKey;

    OrderedMapViewCursor(OrderedMap<K, V> map, OrderedMapCursor<K, V> cursor, K fromKey, K toKey) {
        this.map = map;
        this.cursor = cursor;
        this.fromKey = fromKey;
        this.toKey = toKey;
    }

    @Override
    public boolean isEmpty() {
        return this.cursor.isEmpty() || this.toKey != null && this.compareKey(this.cursor.nextKey(), this.toKey) >= 0;
    }

    @Override
    public Map.Entry<K, V> head() {
        if (!this.isEmpty()) {
            return (Map.Entry)this.cursor.head();
        }
        throw new NoSuchElementException();
    }

    @Override
    public void step() {
        if (this.isEmpty()) {
            throw new UnsupportedOperationException();
        }
        this.cursor.step();
    }

    @Override
    public void skip(long count) {
        this.cursor.skip(count);
    }

    @Override
    public boolean hasNext() {
        return this.cursor.hasNext() && (this.toKey == null || this.compareKey(this.cursor.nextKey(), this.toKey) < 0);
    }

    @Override
    public long nextIndexLong() {
        return this.cursor.nextIndexLong();
    }

    @Override
    public K nextKey() {
        if (this.cursor.hasNext()) {
            K nextKey = this.cursor.nextKey();
            if (this.toKey == null || this.compareKey(nextKey, this.toKey) < 0) {
                return nextKey;
            }
        }
        return null;
    }

    @Override
    public Map.Entry<K, V> next() {
        if (this.hasNext()) {
            return (Map.Entry)this.cursor.next();
        }
        throw new NoSuchElementException();
    }

    @Override
    public boolean hasPrevious() {
        return this.cursor.hasPrevious() && (this.fromKey == null || this.compareKey(this.fromKey, this.cursor.previousKey()) <= 0);
    }

    @Override
    public long previousIndexLong() {
        return this.cursor.previousIndexLong();
    }

    @Override
    public K previousKey() {
        if (this.cursor.hasPrevious()) {
            K previousKey = this.cursor.previousKey();
            if (this.fromKey == null || this.compareKey(this.fromKey, previousKey) <= 0) {
                return previousKey;
            }
        }
        return null;
    }

    @Override
    public Map.Entry<K, V> previous() {
        if (this.hasPrevious()) {
            return (Map.Entry)this.cursor.previous();
        }
        throw new NoSuchElementException();
    }

    @Override
    public void set(Map.Entry<K, V> newValue) {
        this.cursor.set(newValue);
    }

    @Override
    public void remove() {
        this.cursor.remove();
    }

    private int compareKey(Object x, Object y) {
        Comparator<K> comparator = this.map.comparator();
        if (comparator != null) {
            return comparator.compare(x, y);
        }
        return ((Comparable)x).compareTo(y);
    }
}

