/*
 * Decompiled with CFR 0.152.
 */
package swim.util;

import java.util.ListIterator;
import java.util.Map;
import swim.util.CursorArray;
import swim.util.CursorEmpty;
import swim.util.CursorKeys;
import swim.util.CursorUnary;
import swim.util.CursorValues;

public interface Cursor<T>
extends ListIterator<T> {
    public boolean isEmpty();

    public T head();

    public void step();

    public void skip(long var1);

    @Override
    public boolean hasNext();

    public long nextIndexLong();

    @Override
    default public int nextIndex() {
        long k = this.nextIndexLong();
        int i = (int)k;
        if ((long)i != k) {
            throw new IndexOutOfBoundsException("index overflow");
        }
        return i;
    }

    @Override
    public T next();

    @Override
    public boolean hasPrevious();

    public long previousIndexLong();

    @Override
    default public int previousIndex() {
        long k = this.previousIndexLong();
        int i = (int)k;
        if ((long)i != k) {
            throw new IndexOutOfBoundsException("index overflow");
        }
        return i;
    }

    @Override
    public T previous();

    @Override
    default public void set(T object) {
        throw new UnsupportedOperationException();
    }

    @Override
    default public void add(T object) {
        throw new UnsupportedOperationException();
    }

    @Override
    default public void remove() {
        throw new UnsupportedOperationException();
    }

    default public void load() throws InterruptedException {
    }

    public static <T> Cursor<T> empty() {
        return new CursorEmpty();
    }

    public static <T> Cursor<T> unary(T value) {
        return new CursorUnary<T>(value);
    }

    public static <T> Cursor<T> array(Object[] array, int index, int limit) {
        return new CursorArray(array, index, limit);
    }

    public static <T> Cursor<T> array(Object[] array, int index) {
        return new CursorArray(array, index, array.length);
    }

    public static <T> Cursor<T> array(Object[] array) {
        return new CursorArray(array, 0, array.length);
    }

    public static <K> Cursor<K> keys(Cursor<? extends Map.Entry<? extends K, ?>> entries) {
        return new CursorKeys(entries);
    }

    public static <V> Cursor<V> values(Cursor<? extends Map.Entry<?, ? extends V>> entries) {
        return new CursorValues(entries);
    }
}

