/*
 * Decompiled with CFR 0.152.
 */
package swim.util;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceArray;
import swim.util.HashGenCacheSetBucket;

public class HashGenCacheSet<T> {
    final AtomicReferenceArray<HashGenCacheSetBucket<T>> buckets;
    volatile int gen4Hits;
    volatile int gen3Hits;
    volatile int gen2Hits;
    volatile int gen1Hits;
    volatile int misses;
    static final SoftReference<Object> NULL_REF = new SoftReference<Object>(null);
    static final AtomicIntegerFieldUpdater<HashGenCacheSetBucket<?>> BUCKET_GEN4_WEIGHT = AtomicIntegerFieldUpdater.newUpdater(HashGenCacheSetBucket.class, "gen4Weight");
    static final AtomicIntegerFieldUpdater<HashGenCacheSetBucket<?>> BUCKET_GEN3_WEIGHT = AtomicIntegerFieldUpdater.newUpdater(HashGenCacheSetBucket.class, "gen3Weight");
    static final AtomicIntegerFieldUpdater<HashGenCacheSetBucket<?>> BUCKET_GEN2_WEIGHT = AtomicIntegerFieldUpdater.newUpdater(HashGenCacheSetBucket.class, "gen2Weight");
    static final AtomicIntegerFieldUpdater<HashGenCacheSetBucket<?>> BUCKET_GEN1_WEIGHT = AtomicIntegerFieldUpdater.newUpdater(HashGenCacheSetBucket.class, "gen1Weight");
    static final AtomicIntegerFieldUpdater<HashGenCacheSet<?>> GEN4_HITS = AtomicIntegerFieldUpdater.newUpdater(HashGenCacheSet.class, "gen4Hits");
    static final AtomicIntegerFieldUpdater<HashGenCacheSet<?>> GEN3_HITS = AtomicIntegerFieldUpdater.newUpdater(HashGenCacheSet.class, "gen3Hits");
    static final AtomicIntegerFieldUpdater<HashGenCacheSet<?>> GEN2_HITS = AtomicIntegerFieldUpdater.newUpdater(HashGenCacheSet.class, "gen2Hits");
    static final AtomicIntegerFieldUpdater<HashGenCacheSet<?>> GEN1_HITS = AtomicIntegerFieldUpdater.newUpdater(HashGenCacheSet.class, "gen1Hits");
    static final AtomicIntegerFieldUpdater<HashGenCacheSet<?>> MISSES = AtomicIntegerFieldUpdater.newUpdater(HashGenCacheSet.class, "misses");

    public HashGenCacheSet(int size) {
        this.buckets = new AtomicReferenceArray(size);
    }

    public T put(T value) {
        Object gen4Val;
        if (this.buckets.length() == 0) {
            return value;
        }
        int index = Math.abs(value.hashCode()) % this.buckets.length();
        HashGenCacheSetBucket<T> bucket = this.buckets.get(index);
        if (bucket == null) {
            bucket = new HashGenCacheSetBucket();
        }
        if ((gen4Val = bucket.gen4ValRef.get()) != null && value.equals(gen4Val)) {
            GEN4_HITS.incrementAndGet(this);
            BUCKET_GEN4_WEIGHT.incrementAndGet(bucket);
            return gen4Val;
        }
        Object gen3Val = bucket.gen3ValRef.get();
        if (gen3Val != null && value.equals(gen3Val)) {
            GEN3_HITS.incrementAndGet(this);
            if (BUCKET_GEN3_WEIGHT.incrementAndGet(bucket) > bucket.gen4Weight) {
                this.buckets.set(index, new HashGenCacheSetBucket(bucket.gen3ValRef, bucket.gen3Weight, bucket.gen4ValRef, bucket.gen4Weight, bucket.gen2ValRef, bucket.gen2Weight, bucket.gen1ValRef, bucket.gen1Weight));
            }
            return gen3Val;
        }
        Object gen2Val = bucket.gen2ValRef.get();
        if (gen2Val != null && value.equals(gen2Val)) {
            GEN2_HITS.incrementAndGet(this);
            if (BUCKET_GEN2_WEIGHT.incrementAndGet(bucket) > bucket.gen3Weight) {
                this.buckets.set(index, new HashGenCacheSetBucket(bucket.gen4ValRef, bucket.gen4Weight, bucket.gen2ValRef, bucket.gen2Weight, bucket.gen3ValRef, bucket.gen3Weight, bucket.gen1ValRef, bucket.gen1Weight));
            }
            return gen2Val;
        }
        Object gen1Val = bucket.gen1ValRef.get();
        if (gen1Val != null && value.equals(gen1Val)) {
            GEN1_HITS.incrementAndGet(this);
            if (BUCKET_GEN1_WEIGHT.incrementAndGet(bucket) > bucket.gen2Weight) {
                this.buckets.set(index, new HashGenCacheSetBucket(bucket.gen4ValRef, bucket.gen4Weight, bucket.gen3ValRef, bucket.gen3Weight, bucket.gen1ValRef, bucket.gen1Weight, bucket.gen2ValRef, bucket.gen2Weight));
            }
            return gen1Val;
        }
        MISSES.incrementAndGet(this);
        if (gen4Val == null) {
            this.buckets.set(index, new HashGenCacheSetBucket(bucket.gen3ValRef, bucket.gen3Weight, bucket.gen2ValRef, bucket.gen2Weight, bucket.gen1ValRef, bucket.gen1Weight, new SoftReference<T>(value), 1));
        } else if (gen3Val == null) {
            this.buckets.set(index, new HashGenCacheSetBucket(bucket.gen4ValRef, bucket.gen4Weight, bucket.gen2ValRef, bucket.gen2Weight, bucket.gen1ValRef, bucket.gen1Weight, new SoftReference<T>(value), 1));
        } else if (gen2Val == null) {
            this.buckets.set(index, new HashGenCacheSetBucket(bucket.gen4ValRef, bucket.gen4Weight, bucket.gen3ValRef, bucket.gen3Weight, bucket.gen1ValRef, bucket.gen1Weight, new SoftReference<T>(value), 1));
        } else if (gen1Val == null) {
            this.buckets.set(index, new HashGenCacheSetBucket(bucket.gen4ValRef, bucket.gen4Weight, bucket.gen3ValRef, bucket.gen3Weight, bucket.gen2ValRef, bucket.gen2Weight, new SoftReference<T>(value), 1));
        } else {
            this.buckets.set(index, new HashGenCacheSetBucket(bucket.gen4ValRef, bucket.gen4Weight - 1, bucket.gen3ValRef, bucket.gen3Weight - 1, bucket.gen1ValRef, bucket.gen1Weight, new SoftReference<T>(value), 1));
        }
        return value;
    }

    public boolean weaken(T value) {
        if (this.buckets.length() == 0) {
            return false;
        }
        int index = Math.abs(value.hashCode()) % this.buckets.length();
        HashGenCacheSetBucket<T> bucket = this.buckets.get(index);
        if (bucket == null) {
            return false;
        }
        Object gen4Val = bucket.gen4ValRef.get();
        if (gen4Val != null && value.equals(gen4Val)) {
            this.buckets.set(index, new HashGenCacheSetBucket(HashGenCacheSet.weakRef(bucket.gen4ValRef), bucket.gen4Weight, bucket.gen3ValRef, bucket.gen3Weight, bucket.gen2ValRef, bucket.gen2Weight, bucket.gen1ValRef, bucket.gen1Weight));
            return true;
        }
        Object gen3Val = bucket.gen3ValRef.get();
        if (gen3Val != null && value.equals(gen3Val)) {
            this.buckets.set(index, new HashGenCacheSetBucket(bucket.gen4ValRef, bucket.gen4Weight, HashGenCacheSet.weakRef(bucket.gen3ValRef), bucket.gen3Weight, bucket.gen2ValRef, bucket.gen2Weight, bucket.gen1ValRef, bucket.gen1Weight));
            return true;
        }
        Object gen2Val = bucket.gen2ValRef.get();
        if (gen2Val != null && value.equals(gen2Val)) {
            this.buckets.set(index, new HashGenCacheSetBucket(bucket.gen4ValRef, bucket.gen4Weight, bucket.gen3ValRef, bucket.gen3Weight, HashGenCacheSet.weakRef(bucket.gen2ValRef), bucket.gen2Weight, bucket.gen1ValRef, bucket.gen1Weight));
            return true;
        }
        Object gen1Val = bucket.gen1ValRef.get();
        if (gen1Val != null && value.equals(gen1Val)) {
            this.buckets.set(index, new HashGenCacheSetBucket(bucket.gen4ValRef, bucket.gen4Weight, bucket.gen3ValRef, bucket.gen3Weight, bucket.gen2ValRef, bucket.gen2Weight, HashGenCacheSet.weakRef(bucket.gen1ValRef), bucket.gen1Weight));
            return true;
        }
        if (gen4Val == null) {
            this.buckets.set(index, new HashGenCacheSetBucket(bucket.gen3ValRef, bucket.gen3Weight, bucket.gen2ValRef, bucket.gen2Weight, bucket.gen1ValRef, bucket.gen1Weight, HashGenCacheSet.nullRef(), 1));
        } else if (gen3Val == null) {
            this.buckets.set(index, new HashGenCacheSetBucket(bucket.gen4ValRef, bucket.gen4Weight, bucket.gen2ValRef, bucket.gen2Weight, bucket.gen1ValRef, bucket.gen1Weight, HashGenCacheSet.nullRef(), 1));
        } else if (gen2Val == null) {
            this.buckets.set(index, new HashGenCacheSetBucket(bucket.gen4ValRef, bucket.gen4Weight, bucket.gen3ValRef, bucket.gen3Weight, bucket.gen1ValRef, bucket.gen1Weight, HashGenCacheSet.nullRef(), 1));
        } else if (gen1Val == null) {
            this.buckets.set(index, new HashGenCacheSetBucket(bucket.gen4ValRef, bucket.gen4Weight, bucket.gen3ValRef, bucket.gen3Weight, bucket.gen2ValRef, bucket.gen2Weight, HashGenCacheSet.nullRef(), 1));
        }
        return false;
    }

    public boolean remove(T value) {
        if (this.buckets.length() == 0) {
            return false;
        }
        int index = Math.abs(value.hashCode()) % this.buckets.length();
        HashGenCacheSetBucket<T> bucket = this.buckets.get(index);
        if (bucket == null) {
            return false;
        }
        Object gen4Val = bucket.gen4ValRef.get();
        if (gen4Val != null && value.equals(gen4Val)) {
            this.buckets.set(index, new HashGenCacheSetBucket(bucket.gen3ValRef, bucket.gen3Weight, bucket.gen2ValRef, bucket.gen2Weight, bucket.gen1ValRef, bucket.gen1Weight, HashGenCacheSet.nullRef(), 0));
            return true;
        }
        Object gen3Val = bucket.gen3ValRef.get();
        if (gen3Val != null && value.equals(gen3Val)) {
            this.buckets.set(index, new HashGenCacheSetBucket(bucket.gen4ValRef, bucket.gen4Weight, bucket.gen2ValRef, bucket.gen2Weight, bucket.gen1ValRef, bucket.gen1Weight, HashGenCacheSet.nullRef(), 0));
            return true;
        }
        Object gen2Val = bucket.gen2ValRef.get();
        if (gen2Val != null && value.equals(gen2Val)) {
            this.buckets.set(index, new HashGenCacheSetBucket(bucket.gen4ValRef, bucket.gen4Weight, bucket.gen3ValRef, bucket.gen3Weight, bucket.gen1ValRef, bucket.gen1Weight, HashGenCacheSet.nullRef(), 0));
            return true;
        }
        Object gen1Val = bucket.gen1ValRef.get();
        if (gen1Val != null && value.equals(gen1Val)) {
            this.buckets.set(index, new HashGenCacheSetBucket(bucket.gen4ValRef, bucket.gen4Weight, bucket.gen3ValRef, bucket.gen3Weight, bucket.gen2ValRef, bucket.gen2Weight, HashGenCacheSet.nullRef(), 0));
            return true;
        }
        return false;
    }

    public void clear() {
        for (int i = 0; i < this.buckets.length(); ++i) {
            this.buckets.set(i, null);
        }
    }

    long hits() {
        return (long)this.gen4Hits + (long)this.gen3Hits + (long)this.gen2Hits + (long)this.gen1Hits;
    }

    public double hitRatio() {
        double hits = this.hits();
        return hits / (hits + (double)this.misses);
    }

    static final <T> WeakReference<T> weakRef(Reference<T> ref) {
        if (ref instanceof WeakReference) {
            return (WeakReference)ref;
        }
        return new WeakReference<T>(ref.get());
    }

    static final <T> SoftReference<T> nullRef() {
        return NULL_REF;
    }
}

