/*
 * Decompiled with CFR 0.152.
 */
package swim.util;

import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceArray;
import swim.util.HashGenMapBucket;

public class HashGenMap<K, V> {
    final AtomicReferenceArray<HashGenMapBucket<K, V>> buckets;
    volatile long gen4Hits;
    volatile long gen3Hits;
    volatile long gen2Hits;
    volatile long gen1Hits;
    volatile long misses;
    volatile long evicts;
    static final AtomicLongFieldUpdater<HashGenMap<?, ?>> GEN4_HITS = AtomicLongFieldUpdater.newUpdater(HashGenMap.class, "gen4Hits");
    static final AtomicLongFieldUpdater<HashGenMap<?, ?>> GEN3_HITS = AtomicLongFieldUpdater.newUpdater(HashGenMap.class, "gen3Hits");
    static final AtomicLongFieldUpdater<HashGenMap<?, ?>> GEN2_HITS = AtomicLongFieldUpdater.newUpdater(HashGenMap.class, "gen2Hits");
    static final AtomicLongFieldUpdater<HashGenMap<?, ?>> GEN1_HITS = AtomicLongFieldUpdater.newUpdater(HashGenMap.class, "gen1Hits");
    static final AtomicLongFieldUpdater<HashGenMap<?, ?>> MISSES = AtomicLongFieldUpdater.newUpdater(HashGenMap.class, "misses");
    static final AtomicLongFieldUpdater<HashGenMap<?, ?>> EVICTS = AtomicLongFieldUpdater.newUpdater(HashGenMap.class, "evicts");

    public HashGenMap(int size) {
        this.buckets = new AtomicReferenceArray(size);
        this.gen4Hits = 0L;
        this.gen3Hits = 0L;
        this.gen2Hits = 0L;
        this.gen1Hits = 0L;
        this.misses = 0L;
        this.evicts = 0L;
    }

    protected void evict(K key, V value) {
    }

    public V get(K key) {
        Object cacheVal;
        HashGenMapBucket<K, V> newBucket;
        HashGenMapBucket<K, V> oldBucket;
        AtomicReferenceArray<HashGenMapBucket<K, V>> buckets = this.buckets;
        if (buckets.length() == 0) {
            return null;
        }
        int index = Math.abs(key.hashCode()) % buckets.length();
        do {
            if ((oldBucket = buckets.get(index)) == null) {
                newBucket = null;
                cacheVal = null;
                continue;
            }
            if (oldBucket.gen4Key != null && key.equals(oldBucket.gen4Key)) {
                GEN4_HITS.incrementAndGet(this);
                HashGenMapBucket.GEN4_WEIGHT.incrementAndGet(oldBucket);
                newBucket = oldBucket;
                cacheVal = oldBucket.gen4Val;
                continue;
            }
            if (oldBucket.gen3Key != null && key.equals(oldBucket.gen3Key)) {
                GEN3_HITS.incrementAndGet(this);
                newBucket = HashGenMapBucket.GEN3_WEIGHT.incrementAndGet(oldBucket) > oldBucket.gen4Weight ? new HashGenMapBucket(oldBucket.gen3Key, oldBucket.gen3Val, oldBucket.gen3Weight, oldBucket.gen4Key, oldBucket.gen4Val, oldBucket.gen4Weight, oldBucket.gen2Key, oldBucket.gen2Val, oldBucket.gen2Weight, oldBucket.gen1Key, oldBucket.gen1Val, oldBucket.gen1Weight) : oldBucket;
                cacheVal = oldBucket.gen3Val;
                continue;
            }
            if (oldBucket.gen2Key != null && key.equals(oldBucket.gen2Key)) {
                GEN2_HITS.incrementAndGet(this);
                newBucket = HashGenMapBucket.GEN2_WEIGHT.incrementAndGet(oldBucket) > oldBucket.gen3Weight ? new HashGenMapBucket(oldBucket.gen4Key, oldBucket.gen4Val, oldBucket.gen4Weight, oldBucket.gen2Key, oldBucket.gen2Val, oldBucket.gen2Weight, oldBucket.gen3Key, oldBucket.gen3Val, oldBucket.gen3Weight, oldBucket.gen1Key, oldBucket.gen1Val, oldBucket.gen1Weight) : oldBucket;
                cacheVal = oldBucket.gen2Val;
                continue;
            }
            if (oldBucket.gen1Key != null && key.equals(oldBucket.gen1Key)) {
                GEN1_HITS.incrementAndGet(this);
                newBucket = HashGenMapBucket.GEN1_WEIGHT.incrementAndGet(oldBucket) > oldBucket.gen2Weight ? new HashGenMapBucket(oldBucket.gen4Key, oldBucket.gen4Val, oldBucket.gen4Weight, oldBucket.gen3Key, oldBucket.gen3Val, oldBucket.gen3Weight, oldBucket.gen1Key, oldBucket.gen1Val, oldBucket.gen1Weight, oldBucket.gen2Key, oldBucket.gen2Val, oldBucket.gen2Weight) : oldBucket;
                cacheVal = oldBucket.gen1Val;
                continue;
            }
            MISSES.incrementAndGet(this);
            newBucket = oldBucket;
            cacheVal = null;
        } while (oldBucket != newBucket && !buckets.compareAndSet(index, oldBucket, newBucket));
        return cacheVal;
    }

    public V put(K key, V value) {
        V cacheVal;
        HashGenMapBucket<K, V> newBucket;
        HashGenMapBucket<K, V> oldBucket;
        AtomicReferenceArray<HashGenMapBucket<K, V>> buckets = this.buckets;
        if (buckets.length() == 0) {
            return value;
        }
        K evictKey = null;
        V evictVal = null;
        int index = Math.abs(key.hashCode()) % buckets.length();
        do {
            if ((oldBucket = buckets.get(index)) == null) {
                newBucket = new HashGenMapBucket<K, V>(key, value);
                cacheVal = value;
                continue;
            }
            if (oldBucket.gen4Key != null && key.equals(oldBucket.gen4Key)) {
                GEN4_HITS.incrementAndGet(this);
                HashGenMapBucket.GEN4_WEIGHT.incrementAndGet(oldBucket);
                newBucket = oldBucket;
                cacheVal = oldBucket.gen4Val;
                continue;
            }
            if (oldBucket.gen3Key != null && key.equals(oldBucket.gen3Key)) {
                GEN3_HITS.incrementAndGet(this);
                newBucket = HashGenMapBucket.GEN3_WEIGHT.incrementAndGet(oldBucket) > oldBucket.gen4Weight ? new HashGenMapBucket(oldBucket.gen3Key, oldBucket.gen3Val, oldBucket.gen3Weight, oldBucket.gen4Key, oldBucket.gen4Val, oldBucket.gen4Weight, oldBucket.gen2Key, oldBucket.gen2Val, oldBucket.gen2Weight, oldBucket.gen1Key, oldBucket.gen1Val, oldBucket.gen1Weight) : oldBucket;
                cacheVal = oldBucket.gen3Val;
                continue;
            }
            if (oldBucket.gen2Key != null && key.equals(oldBucket.gen2Key)) {
                GEN2_HITS.incrementAndGet(this);
                newBucket = HashGenMapBucket.GEN2_WEIGHT.incrementAndGet(oldBucket) > oldBucket.gen3Weight ? new HashGenMapBucket(oldBucket.gen4Key, oldBucket.gen4Val, oldBucket.gen4Weight, oldBucket.gen2Key, oldBucket.gen2Val, oldBucket.gen2Weight, oldBucket.gen3Key, oldBucket.gen3Val, oldBucket.gen3Weight, oldBucket.gen1Key, oldBucket.gen1Val, oldBucket.gen1Weight) : oldBucket;
                cacheVal = oldBucket.gen2Val;
                continue;
            }
            if (oldBucket.gen1Key != null && key.equals(oldBucket.gen1Key)) {
                GEN1_HITS.incrementAndGet(this);
                newBucket = HashGenMapBucket.GEN1_WEIGHT.incrementAndGet(oldBucket) > oldBucket.gen2Weight ? new HashGenMapBucket(oldBucket.gen4Key, oldBucket.gen4Val, oldBucket.gen4Weight, oldBucket.gen3Key, oldBucket.gen3Val, oldBucket.gen3Weight, oldBucket.gen1Key, oldBucket.gen1Val, oldBucket.gen1Weight, oldBucket.gen2Key, oldBucket.gen2Val, oldBucket.gen2Weight) : oldBucket;
                cacheVal = oldBucket.gen1Val;
                continue;
            }
            MISSES.incrementAndGet(this);
            evictKey = oldBucket.gen2Key;
            evictVal = oldBucket.gen2Val;
            newBucket = new HashGenMapBucket(oldBucket.gen4Key, oldBucket.gen4Val, oldBucket.gen4Weight - 1, oldBucket.gen3Key, oldBucket.gen3Val, oldBucket.gen3Weight - 1, oldBucket.gen1Key, oldBucket.gen1Val, oldBucket.gen1Weight, key, value, 1);
            cacheVal = value;
        } while (oldBucket != newBucket && !buckets.compareAndSet(index, oldBucket, newBucket));
        if (evictKey != null) {
            EVICTS.incrementAndGet(this);
            this.evict(evictKey, evictVal);
        }
        return cacheVal;
    }

    public V remove(K key) {
        Object cacheVal;
        HashGenMapBucket<Object, Object> newBucket;
        HashGenMapBucket<K, V> oldBucket;
        AtomicReferenceArray<HashGenMapBucket<K, V>> buckets = this.buckets;
        if (buckets.length() == 0) {
            return null;
        }
        int index = Math.abs(key.hashCode()) % buckets.length();
        do {
            if ((oldBucket = buckets.get(index)) == null) {
                cacheVal = null;
                newBucket = null;
                continue;
            }
            if (oldBucket.gen4Key != null && key.equals(oldBucket.gen4Key)) {
                cacheVal = oldBucket.gen4Val;
                newBucket = new HashGenMapBucket<Object, Object>(oldBucket.gen3Key, oldBucket.gen3Val, oldBucket.gen3Weight, oldBucket.gen2Key, oldBucket.gen2Val, oldBucket.gen2Weight, oldBucket.gen1Key, oldBucket.gen1Val, oldBucket.gen1Weight, null, null, 0);
                continue;
            }
            if (oldBucket.gen3Key != null && key.equals(oldBucket.gen3Key)) {
                cacheVal = oldBucket.gen3Val;
                newBucket = new HashGenMapBucket<Object, Object>(oldBucket.gen4Key, oldBucket.gen4Val, oldBucket.gen4Weight, oldBucket.gen2Key, oldBucket.gen2Val, oldBucket.gen2Weight, oldBucket.gen1Key, oldBucket.gen1Val, oldBucket.gen1Weight, null, null, 0);
                continue;
            }
            if (oldBucket.gen2Key != null && key.equals(oldBucket.gen2Key)) {
                cacheVal = oldBucket.gen2Val;
                newBucket = new HashGenMapBucket<Object, Object>(oldBucket.gen4Key, oldBucket.gen4Val, oldBucket.gen4Weight, oldBucket.gen3Key, oldBucket.gen3Val, oldBucket.gen3Weight, oldBucket.gen1Key, oldBucket.gen1Val, oldBucket.gen1Weight, null, null, 0);
                continue;
            }
            if (oldBucket.gen1Key != null && key.equals(oldBucket.gen1Key)) {
                cacheVal = oldBucket.gen1Val;
                newBucket = new HashGenMapBucket<Object, Object>(oldBucket.gen4Key, oldBucket.gen4Val, oldBucket.gen4Weight, oldBucket.gen3Key, oldBucket.gen3Val, oldBucket.gen3Weight, oldBucket.gen2Key, oldBucket.gen2Val, oldBucket.gen2Weight, null, null, 0);
                continue;
            }
            cacheVal = null;
            newBucket = oldBucket;
        } while (oldBucket != newBucket && !buckets.compareAndSet(index, oldBucket, newBucket));
        return cacheVal;
    }

    public void clear() {
        AtomicReferenceArray<HashGenMapBucket<K, V>> buckets = this.buckets;
        for (int i = 0; i < buckets.length(); ++i) {
            buckets.set(i, null);
        }
    }

    public double hitRatio() {
        double hits = (double)GEN4_HITS.get(this) + (double)GEN3_HITS.get(this) + (double)GEN2_HITS.get(this) + (double)GEN1_HITS.get(this);
        return hits / (hits + (double)MISSES.get(this));
    }
}

