/*
 * Decompiled with CFR 0.152.
 */
package swim.util;

import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceArray;
import swim.util.HashGenSetBucket;

public class HashGenSet<V> {
    final AtomicReferenceArray<HashGenSetBucket<V>> buckets;
    volatile long gen4Hits;
    volatile long gen3Hits;
    volatile long gen2Hits;
    volatile long gen1Hits;
    volatile long misses;
    volatile long evicts;
    static final AtomicLongFieldUpdater<HashGenSet<?>> GEN4_HITS = AtomicLongFieldUpdater.newUpdater(HashGenSet.class, "gen4Hits");
    static final AtomicLongFieldUpdater<HashGenSet<?>> GEN3_HITS = AtomicLongFieldUpdater.newUpdater(HashGenSet.class, "gen3Hits");
    static final AtomicLongFieldUpdater<HashGenSet<?>> GEN2_HITS = AtomicLongFieldUpdater.newUpdater(HashGenSet.class, "gen2Hits");
    static final AtomicLongFieldUpdater<HashGenSet<?>> GEN1_HITS = AtomicLongFieldUpdater.newUpdater(HashGenSet.class, "gen1Hits");
    static final AtomicLongFieldUpdater<HashGenSet<?>> MISSES = AtomicLongFieldUpdater.newUpdater(HashGenSet.class, "misses");
    static final AtomicLongFieldUpdater<HashGenSet<?>> EVICTS = AtomicLongFieldUpdater.newUpdater(HashGenSet.class, "evicts");

    public HashGenSet(int size) {
        this.buckets = new AtomicReferenceArray(size);
        this.gen4Hits = 0L;
        this.gen3Hits = 0L;
        this.gen2Hits = 0L;
        this.gen1Hits = 0L;
        this.misses = 0L;
        this.evicts = 0L;
    }

    protected void evict(V value) {
    }

    public V put(V value) {
        V cacheVal;
        HashGenSetBucket<V> newBucket;
        HashGenSetBucket<V> oldBucket;
        AtomicReferenceArray<HashGenSetBucket<V>> buckets = this.buckets;
        if (buckets.length() == 0) {
            return value;
        }
        V evictVal = null;
        int index = Math.abs(value.hashCode()) % buckets.length();
        do {
            if ((oldBucket = buckets.get(index)) == null) {
                newBucket = new HashGenSetBucket<V>(value);
                cacheVal = value;
                continue;
            }
            if (oldBucket.gen4Val != null && value.equals(oldBucket.gen4Val)) {
                GEN4_HITS.incrementAndGet(this);
                HashGenSetBucket.GEN4_WEIGHT.incrementAndGet(oldBucket);
                newBucket = oldBucket;
                cacheVal = oldBucket.gen4Val;
                continue;
            }
            if (oldBucket.gen3Val != null && value.equals(oldBucket.gen3Val)) {
                GEN3_HITS.incrementAndGet(this);
                newBucket = HashGenSetBucket.GEN3_WEIGHT.incrementAndGet(oldBucket) > oldBucket.gen4Weight ? new HashGenSetBucket(oldBucket.gen3Val, oldBucket.gen3Weight, oldBucket.gen4Val, oldBucket.gen4Weight, oldBucket.gen2Val, oldBucket.gen2Weight, oldBucket.gen1Val, oldBucket.gen1Weight) : oldBucket;
                cacheVal = oldBucket.gen3Val;
                continue;
            }
            if (oldBucket.gen2Val != null && value.equals(oldBucket.gen2Val)) {
                GEN2_HITS.incrementAndGet(this);
                newBucket = HashGenSetBucket.GEN2_WEIGHT.incrementAndGet(oldBucket) > oldBucket.gen3Weight ? new HashGenSetBucket(oldBucket.gen4Val, oldBucket.gen4Weight, oldBucket.gen2Val, oldBucket.gen2Weight, oldBucket.gen3Val, oldBucket.gen3Weight, oldBucket.gen1Val, oldBucket.gen1Weight) : oldBucket;
                cacheVal = oldBucket.gen2Val;
                continue;
            }
            if (oldBucket.gen1Val != null && value.equals(oldBucket.gen1Val)) {
                GEN1_HITS.incrementAndGet(this);
                newBucket = HashGenSetBucket.GEN1_WEIGHT.incrementAndGet(oldBucket) > oldBucket.gen2Weight ? new HashGenSetBucket(oldBucket.gen4Val, oldBucket.gen4Weight, oldBucket.gen3Val, oldBucket.gen3Weight, oldBucket.gen1Val, oldBucket.gen1Weight, oldBucket.gen2Val, oldBucket.gen2Weight) : oldBucket;
                cacheVal = oldBucket.gen1Val;
                continue;
            }
            MISSES.incrementAndGet(this);
            evictVal = oldBucket.gen2Val;
            newBucket = new HashGenSetBucket(oldBucket.gen4Val, oldBucket.gen4Weight - 1, oldBucket.gen3Val, oldBucket.gen3Weight - 1, oldBucket.gen1Val, oldBucket.gen1Weight, value, 1);
            cacheVal = value;
        } while (oldBucket != newBucket && !buckets.compareAndSet(index, oldBucket, newBucket));
        if (evictVal != null) {
            EVICTS.incrementAndGet(this);
            this.evict(evictVal);
        }
        return cacheVal;
    }

    public boolean remove(V value) {
        boolean removed;
        HashGenSetBucket<Object> newBucket;
        HashGenSetBucket<V> oldBucket;
        AtomicReferenceArray<HashGenSetBucket<V>> buckets = this.buckets;
        if (buckets.length() == 0) {
            return false;
        }
        int index = Math.abs(value.hashCode()) % buckets.length();
        do {
            if ((oldBucket = buckets.get(index)) == null) {
                newBucket = null;
                removed = false;
                continue;
            }
            if (oldBucket.gen4Val != null && value.equals(oldBucket.gen4Val)) {
                newBucket = new HashGenSetBucket<Object>(oldBucket.gen3Val, oldBucket.gen3Weight, oldBucket.gen2Val, oldBucket.gen2Weight, oldBucket.gen1Val, oldBucket.gen1Weight, null, 0);
                removed = true;
                continue;
            }
            if (oldBucket.gen3Val != null && value.equals(oldBucket.gen3Val)) {
                newBucket = new HashGenSetBucket<Object>(oldBucket.gen4Val, oldBucket.gen4Weight, oldBucket.gen2Val, oldBucket.gen2Weight, oldBucket.gen1Val, oldBucket.gen1Weight, null, 0);
                removed = true;
                continue;
            }
            if (oldBucket.gen2Val != null && value.equals(oldBucket.gen2Val)) {
                newBucket = new HashGenSetBucket<Object>(oldBucket.gen4Val, oldBucket.gen4Weight, oldBucket.gen3Val, oldBucket.gen3Weight, oldBucket.gen1Val, oldBucket.gen1Weight, null, 0);
                removed = true;
                continue;
            }
            if (oldBucket.gen1Val != null && value.equals(oldBucket.gen1Val)) {
                newBucket = new HashGenSetBucket<Object>(oldBucket.gen4Val, oldBucket.gen4Weight, oldBucket.gen3Val, oldBucket.gen3Weight, oldBucket.gen2Val, oldBucket.gen2Weight, null, 0);
                removed = true;
                continue;
            }
            newBucket = oldBucket;
            removed = false;
        } while (oldBucket != newBucket && !buckets.compareAndSet(index, oldBucket, newBucket));
        return removed;
    }

    public void clear() {
        AtomicReferenceArray<HashGenSetBucket<V>> buckets = this.buckets;
        for (int i = 0; i < buckets.length(); ++i) {
            buckets.set(i, null);
        }
    }

    public double hitRatio() {
        double hits = (double)GEN4_HITS.get(this) + (double)GEN3_HITS.get(this) + (double)GEN2_HITS.get(this) + (double)GEN1_HITS.get(this);
        return hits / (hits + (double)MISSES.get(this));
    }
}

