/*
 * Decompiled with CFR 0.152.
 */
package swim.util;

import java.util.Comparator;
import java.util.Map;
import swim.util.Cursor;
import swim.util.OrderedMap;
import swim.util.OrderedMapCursor;
import swim.util.OrderedMapViewCursor;

final class OrderedMapView<K, V>
implements OrderedMap<K, V> {
    final OrderedMap<K, V> map;
    final K fromKey;
    final K toKey;

    OrderedMapView(OrderedMap<K, V> map, K fromKey, K toKey) {
        this.map = map;
        this.fromKey = fromKey;
        this.toKey = toKey;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public int size() {
        int toIndex;
        int fromIndex;
        if (this.fromKey != null) {
            fromIndex = this.map.indexOf(this.fromKey);
            if (fromIndex < 0) {
                fromIndex = -(fromIndex + 1);
            }
        } else {
            fromIndex = 0;
        }
        toIndex = this.toKey != null ? ((toIndex = this.map.indexOf(this.toKey)) < 0 ? -(toIndex + 1) : ++toIndex) : this.map.size();
        return toIndex - fromIndex;
    }

    @Override
    public boolean containsKey(Object key) {
        return !(this.fromKey != null && this.compareKey(this.fromKey, key) < 0 || this.toKey != null && this.compareKey(key, this.toKey) >= 0 || !this.map.containsKey(key));
    }

    @Override
    public boolean containsValue(Object value) {
        Cursor cursor = this.valueIterator();
        while (cursor.hasNext()) {
            if (!(value == null ? cursor.next() == null : value.equals(cursor.next()))) continue;
            return true;
        }
        return false;
    }

    @Override
    public int indexOf(Object key) {
        if (!(this.fromKey != null && this.compareKey(this.fromKey, key) < 0 || this.toKey != null && this.compareKey(key, this.toKey) >= 0)) {
            int keyIndex;
            int fromIndex;
            if (this.fromKey != null) {
                fromIndex = this.map.indexOf(this.fromKey);
                if (fromIndex < 0) {
                    fromIndex = -(fromIndex + 1);
                }
            } else {
                fromIndex = 0;
            }
            if ((keyIndex = this.map.indexOf(key)) >= 0) {
                return keyIndex - fromIndex;
            }
            return keyIndex + fromIndex;
        }
        throw new IllegalArgumentException(key.toString());
    }

    @Override
    public V get(Object key) {
        if (!(this.fromKey != null && this.compareKey(this.fromKey, key) < 0 || this.toKey != null && this.compareKey(key, this.toKey) >= 0)) {
            return this.map.get(key);
        }
        return null;
    }

    @Override
    public Map.Entry<K, V> getEntry(Object key) {
        if (!(this.fromKey != null && this.compareKey(this.fromKey, key) < 0 || this.toKey != null && this.compareKey(key, this.toKey) >= 0)) {
            return this.map.getEntry(key);
        }
        return null;
    }

    @Override
    public Map.Entry<K, V> getIndex(int index) {
        int i;
        Cursor cursor = this.iterator();
        for (i = 0; i < index && cursor.hasNext(); ++i) {
            cursor.step();
        }
        if (i == index && cursor.hasNext()) {
            return (Map.Entry)cursor.next();
        }
        throw new IndexOutOfBoundsException(Integer.toString(index));
    }

    @Override
    public Map.Entry<K, V> firstEntry() {
        Map.Entry<K, V> nextEntry;
        if (this.fromKey != null) {
            nextEntry = this.map.getEntry(this.fromKey);
            if (nextEntry != null) {
                return nextEntry;
            }
            nextEntry = this.map.nextEntry(this.fromKey);
        } else {
            nextEntry = this.map.firstEntry();
        }
        if (this.toKey == null || nextEntry != null && this.compareKey(nextEntry.getKey(), this.toKey) < 0) {
            return nextEntry;
        }
        return null;
    }

    @Override
    public K firstKey() {
        K nextKey;
        if (this.fromKey != null) {
            if (this.map.containsKey(this.fromKey)) {
                return this.fromKey;
            }
            nextKey = this.map.nextKey(this.fromKey);
        } else {
            nextKey = this.map.firstKey();
        }
        if (this.toKey == null || nextKey != null && this.compareKey(nextKey, this.toKey) < 0) {
            return nextKey;
        }
        return null;
    }

    @Override
    public V firstValue() {
        K firstKey = this.firstKey();
        if (firstKey != null) {
            return this.map.get(firstKey);
        }
        return null;
    }

    @Override
    public Map.Entry<K, V> lastEntry() {
        Map.Entry<K, V> previousEntry = this.toKey != null ? this.map.previousEntry(this.toKey) : this.map.lastEntry();
        if (this.fromKey == null || previousEntry != null && this.compareKey(this.fromKey, previousEntry.getKey()) <= 0) {
            return previousEntry;
        }
        return null;
    }

    @Override
    public K lastKey() {
        K previousKey = this.toKey != null ? this.map.previousKey(this.toKey) : this.map.lastKey();
        if (this.fromKey == null || previousKey != null && this.compareKey(this.fromKey, previousKey) <= 0) {
            return previousKey;
        }
        return null;
    }

    @Override
    public V lastValue() {
        K lastKey = this.lastKey();
        if (lastKey != null) {
            return this.map.get(lastKey);
        }
        return null;
    }

    @Override
    public Map.Entry<K, V> nextEntry(K key) {
        Map.Entry<K, V> nextEntry = this.map.nextEntry(key);
        if (nextEntry != null && (this.toKey == null || this.compareKey(nextEntry.getKey(), this.toKey) < 0)) {
            return nextEntry;
        }
        return null;
    }

    @Override
    public K nextKey(K key) {
        K nextKey = this.map.nextKey(key);
        if (nextKey != null && (this.toKey == null || this.compareKey(nextKey, this.toKey) < 0)) {
            return nextKey;
        }
        return null;
    }

    @Override
    public V nextValue(K key) {
        K nextKey = this.nextKey(key);
        if (nextKey != null) {
            return this.map.get(nextKey);
        }
        return null;
    }

    @Override
    public Map.Entry<K, V> previousEntry(K key) {
        Map.Entry<K, V> previousEntry = this.map.previousEntry(key);
        if (previousEntry != null && (this.fromKey == null || this.compareKey(this.fromKey, previousEntry.getKey()) <= 0)) {
            return previousEntry;
        }
        return null;
    }

    @Override
    public K previousKey(K key) {
        K previousKey = this.map.previousKey(key);
        if (previousKey != null && (this.fromKey == null || this.compareKey(this.fromKey, previousKey) <= 0)) {
            return previousKey;
        }
        return null;
    }

    @Override
    public V previousValue(K key) {
        K previousKey = this.previousKey(key);
        if (previousKey != null) {
            return this.map.get(previousKey);
        }
        return null;
    }

    @Override
    public V put(K key, V newValue) {
        if (!(this.fromKey != null && this.compareKey(this.fromKey, key) > 0 || this.toKey != null && this.compareKey(key, this.toKey) >= 0)) {
            return this.map.put(key, newValue);
        }
        throw new IllegalArgumentException(key.toString());
    }

    @Override
    public V remove(Object key) {
        if (!(this.fromKey != null && this.compareKey(this.fromKey, key) > 0 || this.toKey != null && this.compareKey(key, this.toKey) >= 0)) {
            return this.map.remove(key);
        }
        return null;
    }

    @Override
    public void clear() {
        Cursor cursor = this.keyIterator();
        while (cursor.hasNext()) {
            cursor.step();
            cursor.remove();
        }
    }

    @Override
    public OrderedMap<K, V> headMap(K toKey) {
        if (this.compareKey(toKey, this.toKey) > 0) {
            toKey = this.toKey;
        }
        return new OrderedMapView<K, V>(this.map, this.fromKey, toKey);
    }

    @Override
    public OrderedMap<K, V> tailMap(K fromKey) {
        if (this.compareKey(fromKey, this.fromKey) < 0) {
            fromKey = this.fromKey;
        }
        return new OrderedMapView<K, V>(this.map, fromKey, this.toKey);
    }

    @Override
    public OrderedMap<K, V> subMap(K fromKey, K toKey) {
        if (this.compareKey(fromKey, this.fromKey) < 0) {
            fromKey = this.fromKey;
        }
        if (this.compareKey(toKey, this.toKey) > 0) {
            toKey = this.toKey;
        }
        return new OrderedMapView<K, V>(this.map, fromKey, toKey);
    }

    @Override
    public OrderedMapCursor<K, V> iterator() {
        int index = this.map.indexOf(this.fromKey);
        if (index < 0) {
            index = -(index + 1);
        }
        Cursor cursor = this.map.iterator();
        cursor.skip(index - 1);
        return new OrderedMapViewCursor<K, V>(this.map, cursor, this.fromKey, this.toKey);
    }

    @Override
    public Comparator<? super K> comparator() {
        return this.map.comparator();
    }

    private int compareKey(Object x, Object y) {
        Comparator<K> comparator = this.map.comparator();
        if (comparator != null) {
            return comparator.compare(x, y);
        }
        return ((Comparable)x).compareTo(y);
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Map) {
            Map that = (Map)other;
            if (this.size() == that.size()) {
                for (Map.Entry entry : that.entrySet()) {
                    V value = this.get(entry.getKey());
                    Object v = entry.getValue();
                    if (!(value == null ? v != null : !value.equals(v))) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        int code = 0;
        Cursor these = this.iterator();
        while (these.hasNext()) {
            code += ((Map.Entry)these.next()).hashCode();
        }
        return code;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        Cursor these = this.iterator();
        if (these.hasNext()) {
            sb.append(these.next());
            while (these.hasNext()) {
                sb.append(", ").append(these.next());
            }
        }
        sb.append('}');
        return sb.toString();
    }
}

