/*
 * Decompiled with CFR 0.152.
 */
package swim.util;

import swim.util.Murmur3;

public final class Severity
implements Comparable<Severity> {
    final int level;
    final String label;
    private static int hashSeed;
    public static final int TRACE_LEVEL = 0;
    public static final int DEBUG_LEVEL = 1;
    public static final int INFO_LEVEL = 2;
    public static final int NOTE_LEVEL = 3;
    public static final int WARNING_LEVEL = 4;
    public static final int ERROR_LEVEL = 5;
    public static final int ALERT_LEVEL = 6;
    public static final int FATAL_LEVEL = 7;
    private static Severity trace;
    private static Severity debug;
    private static Severity info;
    private static Severity note;
    private static Severity warning;
    private static Severity error;
    private static Severity alert;
    private static Severity fatal;

    private Severity(int level, String label) {
        this.level = level;
        this.label = label;
    }

    public int level() {
        return this.level;
    }

    public String label() {
        return this.label;
    }

    public Severity label(String label) {
        if (this.label.equals(label)) {
            return this;
        }
        return Severity.create(this.level, label);
    }

    public boolean isTrace() {
        return this.level == 0;
    }

    public boolean isDebug() {
        return this.level == 1;
    }

    public boolean isInfo() {
        return this.level == 2;
    }

    public boolean isNote() {
        return this.level == 3;
    }

    public boolean isWarning() {
        return this.level == 4;
    }

    public boolean isError() {
        return this.level == 5;
    }

    public boolean isAlert() {
        return this.level == 6;
    }

    public boolean isFatal() {
        return this.level == 7;
    }

    @Override
    public int compareTo(Severity that) {
        if (this == that) {
            return 0;
        }
        if (this.level < that.level) {
            return -1;
        }
        if (this.level > that.level) {
            return 1;
        }
        return this.label.compareTo(that.label);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Severity) {
            Severity that = (Severity)other;
            return this.level == that.level && this.label.equals(that.label);
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(Severity.class);
        }
        return Murmur3.mash(Murmur3.mix(Murmur3.mix(hashSeed, this.level), this.label.hashCode()));
    }

    public String toString() {
        return this.label;
    }

    public static Severity create(int level, String label) {
        switch (level) {
            case 0: {
                return Severity.trace(label);
            }
            case 1: {
                return Severity.debug(label);
            }
            case 2: {
                return Severity.info(label);
            }
            case 3: {
                return Severity.note(label);
            }
            case 4: {
                return Severity.warning(label);
            }
            case 5: {
                return Severity.error(label);
            }
            case 6: {
                return Severity.alert(label);
            }
            case 7: {
                return Severity.fatal(label);
            }
        }
        throw new IllegalArgumentException(Integer.toString(level));
    }

    public static Severity from(int level) {
        return Severity.create(level, null);
    }

    public static Severity trace() {
        if (trace == null) {
            trace = new Severity(0, "trace");
        }
        return trace;
    }

    public static Severity trace(String label) {
        if (label == null || "trace".equals(label)) {
            return Severity.trace();
        }
        return new Severity(0, label);
    }

    public static Severity debug() {
        if (debug == null) {
            debug = new Severity(1, "debug");
        }
        return debug;
    }

    public static Severity debug(String label) {
        if (label == null || "debug".equals(label)) {
            return Severity.debug();
        }
        return new Severity(1, label);
    }

    public static Severity info() {
        if (info == null) {
            info = new Severity(2, "info");
        }
        return info;
    }

    public static Severity info(String label) {
        if (label == null || "info".equals(label)) {
            return Severity.info();
        }
        return new Severity(2, label);
    }

    public static Severity note() {
        if (note == null) {
            note = new Severity(3, "note");
        }
        return note;
    }

    public static Severity note(String label) {
        if (label == null || "note".equals(label)) {
            return Severity.note();
        }
        return new Severity(3, label);
    }

    public static Severity warning() {
        if (warning == null) {
            warning = new Severity(4, "warning");
        }
        return warning;
    }

    public static Severity warning(String label) {
        if (label == null || "warning".equals(label)) {
            return Severity.warning();
        }
        return new Severity(4, label);
    }

    public static Severity error() {
        if (error == null) {
            error = new Severity(5, "error");
        }
        return error;
    }

    public static Severity error(String label) {
        if (label == null || "error".equals(label)) {
            return Severity.error();
        }
        return new Severity(5, label);
    }

    public static Severity alert() {
        if (alert == null) {
            alert = new Severity(6, "alert");
        }
        return alert;
    }

    public static Severity alert(String label) {
        if (label == null || "alert".equals(label)) {
            return Severity.alert();
        }
        return new Severity(6, label);
    }

    public static Severity fatal() {
        if (fatal == null) {
            fatal = new Severity(7, "fatal");
        }
        return fatal;
    }

    public static Severity fatal(String label) {
        if (label == null || "fatal".equals(label)) {
            return Severity.fatal();
        }
        return new Severity(7, label);
    }
}

