/*
 * Decompiled with CFR 0.152.
 */
package swim.util;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceArray;
import swim.util.HashGenCacheSetBucket;

public class HashGenCacheSet<T> {
    final AtomicReferenceArray<HashGenCacheSetBucket<T>> buckets;
    volatile long gen4Hits;
    volatile long gen3Hits;
    volatile long gen2Hits;
    volatile long gen1Hits;
    volatile long misses;
    static final AtomicLongFieldUpdater<HashGenCacheSet<?>> GEN4_HITS = AtomicLongFieldUpdater.newUpdater(HashGenCacheSet.class, "gen4Hits");
    static final AtomicLongFieldUpdater<HashGenCacheSet<?>> GEN3_HITS = AtomicLongFieldUpdater.newUpdater(HashGenCacheSet.class, "gen3Hits");
    static final AtomicLongFieldUpdater<HashGenCacheSet<?>> GEN2_HITS = AtomicLongFieldUpdater.newUpdater(HashGenCacheSet.class, "gen2Hits");
    static final AtomicLongFieldUpdater<HashGenCacheSet<?>> GEN1_HITS = AtomicLongFieldUpdater.newUpdater(HashGenCacheSet.class, "gen1Hits");
    static final AtomicLongFieldUpdater<HashGenCacheSet<?>> MISSES = AtomicLongFieldUpdater.newUpdater(HashGenCacheSet.class, "misses");
    static final SoftReference<Object> NULL_REF = new SoftReference<Object>(null);

    public HashGenCacheSet(int size) {
        this.buckets = new AtomicReferenceArray(size);
        this.gen4Hits = 0L;
        this.gen3Hits = 0L;
        this.gen2Hits = 0L;
        this.gen1Hits = 0L;
        this.misses = 0L;
    }

    public T put(T value) {
        Object gen4Val;
        if (this.buckets.length() == 0) {
            return value;
        }
        int index = Math.abs(value.hashCode()) % this.buckets.length();
        HashGenCacheSetBucket<T> bucket = this.buckets.get(index);
        if (bucket == null) {
            bucket = new HashGenCacheSetBucket();
        }
        if ((gen4Val = bucket.gen4ValRef.get()) != null && value.equals(gen4Val)) {
            GEN4_HITS.incrementAndGet(this);
            HashGenCacheSetBucket.GEN4_WEIGHT.incrementAndGet(bucket);
            return gen4Val;
        }
        Object gen3Val = bucket.gen3ValRef.get();
        if (gen3Val != null && value.equals(gen3Val)) {
            GEN3_HITS.incrementAndGet(this);
            if (HashGenCacheSetBucket.GEN3_WEIGHT.incrementAndGet(bucket) > bucket.gen4Weight) {
                this.buckets.set(index, new HashGenCacheSetBucket(bucket.gen3ValRef, bucket.gen3Weight, bucket.gen4ValRef, bucket.gen4Weight, bucket.gen2ValRef, bucket.gen2Weight, bucket.gen1ValRef, bucket.gen1Weight));
            }
            return gen3Val;
        }
        Object gen2Val = bucket.gen2ValRef.get();
        if (gen2Val != null && value.equals(gen2Val)) {
            GEN2_HITS.incrementAndGet(this);
            if (HashGenCacheSetBucket.GEN2_WEIGHT.incrementAndGet(bucket) > bucket.gen3Weight) {
                this.buckets.set(index, new HashGenCacheSetBucket(bucket.gen4ValRef, bucket.gen4Weight, bucket.gen2ValRef, bucket.gen2Weight, bucket.gen3ValRef, bucket.gen3Weight, bucket.gen1ValRef, bucket.gen1Weight));
            }
            return gen2Val;
        }
        Object gen1Val = bucket.gen1ValRef.get();
        if (gen1Val != null && value.equals(gen1Val)) {
            GEN1_HITS.incrementAndGet(this);
            if (HashGenCacheSetBucket.GEN1_WEIGHT.incrementAndGet(bucket) > bucket.gen2Weight) {
                this.buckets.set(index, new HashGenCacheSetBucket(bucket.gen4ValRef, bucket.gen4Weight, bucket.gen3ValRef, bucket.gen3Weight, bucket.gen1ValRef, bucket.gen1Weight, bucket.gen2ValRef, bucket.gen2Weight));
            }
            return gen1Val;
        }
        MISSES.incrementAndGet(this);
        if (gen4Val == null) {
            this.buckets.set(index, new HashGenCacheSetBucket(bucket.gen3ValRef, bucket.gen3Weight, bucket.gen2ValRef, bucket.gen2Weight, bucket.gen1ValRef, bucket.gen1Weight, new SoftReference<T>(value), 1));
        } else if (gen3Val == null) {
            this.buckets.set(index, new HashGenCacheSetBucket(bucket.gen4ValRef, bucket.gen4Weight, bucket.gen2ValRef, bucket.gen2Weight, bucket.gen1ValRef, bucket.gen1Weight, new SoftReference<T>(value), 1));
        } else if (gen2Val == null) {
            this.buckets.set(index, new HashGenCacheSetBucket(bucket.gen4ValRef, bucket.gen4Weight, bucket.gen3ValRef, bucket.gen3Weight, bucket.gen1ValRef, bucket.gen1Weight, new SoftReference<T>(value), 1));
        } else if (gen1Val == null) {
            this.buckets.set(index, new HashGenCacheSetBucket(bucket.gen4ValRef, bucket.gen4Weight, bucket.gen3ValRef, bucket.gen3Weight, bucket.gen2ValRef, bucket.gen2Weight, new SoftReference<T>(value), 1));
        } else {
            this.buckets.set(index, new HashGenCacheSetBucket(bucket.gen4ValRef, bucket.gen4Weight - 1, bucket.gen3ValRef, bucket.gen3Weight - 1, bucket.gen1ValRef, bucket.gen1Weight, new SoftReference<T>(value), 1));
        }
        return value;
    }

    public boolean weaken(T value) {
        if (this.buckets.length() == 0) {
            return false;
        }
        int index = Math.abs(value.hashCode()) % this.buckets.length();
        HashGenCacheSetBucket<T> bucket = this.buckets.get(index);
        if (bucket == null) {
            return false;
        }
        Object gen4Val = bucket.gen4ValRef.get();
        if (gen4Val != null && value.equals(gen4Val)) {
            this.buckets.set(index, new HashGenCacheSetBucket(HashGenCacheSet.weakRef(bucket.gen4ValRef), bucket.gen4Weight, bucket.gen3ValRef, bucket.gen3Weight, bucket.gen2ValRef, bucket.gen2Weight, bucket.gen1ValRef, bucket.gen1Weight));
            return true;
        }
        Object gen3Val = bucket.gen3ValRef.get();
        if (gen3Val != null && value.equals(gen3Val)) {
            this.buckets.set(index, new HashGenCacheSetBucket(bucket.gen4ValRef, bucket.gen4Weight, HashGenCacheSet.weakRef(bucket.gen3ValRef), bucket.gen3Weight, bucket.gen2ValRef, bucket.gen2Weight, bucket.gen1ValRef, bucket.gen1Weight));
            return true;
        }
        Object gen2Val = bucket.gen2ValRef.get();
        if (gen2Val != null && value.equals(gen2Val)) {
            this.buckets.set(index, new HashGenCacheSetBucket(bucket.gen4ValRef, bucket.gen4Weight, bucket.gen3ValRef, bucket.gen3Weight, HashGenCacheSet.weakRef(bucket.gen2ValRef), bucket.gen2Weight, bucket.gen1ValRef, bucket.gen1Weight));
            return true;
        }
        Object gen1Val = bucket.gen1ValRef.get();
        if (gen1Val != null && value.equals(gen1Val)) {
            this.buckets.set(index, new HashGenCacheSetBucket(bucket.gen4ValRef, bucket.gen4Weight, bucket.gen3ValRef, bucket.gen3Weight, bucket.gen2ValRef, bucket.gen2Weight, HashGenCacheSet.weakRef(bucket.gen1ValRef), bucket.gen1Weight));
            return true;
        }
        if (gen4Val == null) {
            this.buckets.set(index, new HashGenCacheSetBucket(bucket.gen3ValRef, bucket.gen3Weight, bucket.gen2ValRef, bucket.gen2Weight, bucket.gen1ValRef, bucket.gen1Weight, HashGenCacheSet.nullRef(), 1));
        } else if (gen3Val == null) {
            this.buckets.set(index, new HashGenCacheSetBucket(bucket.gen4ValRef, bucket.gen4Weight, bucket.gen2ValRef, bucket.gen2Weight, bucket.gen1ValRef, bucket.gen1Weight, HashGenCacheSet.nullRef(), 1));
        } else if (gen2Val == null) {
            this.buckets.set(index, new HashGenCacheSetBucket(bucket.gen4ValRef, bucket.gen4Weight, bucket.gen3ValRef, bucket.gen3Weight, bucket.gen1ValRef, bucket.gen1Weight, HashGenCacheSet.nullRef(), 1));
        } else if (gen1Val == null) {
            this.buckets.set(index, new HashGenCacheSetBucket(bucket.gen4ValRef, bucket.gen4Weight, bucket.gen3ValRef, bucket.gen3Weight, bucket.gen2ValRef, bucket.gen2Weight, HashGenCacheSet.nullRef(), 1));
        }
        return false;
    }

    public boolean remove(T value) {
        if (this.buckets.length() == 0) {
            return false;
        }
        int index = Math.abs(value.hashCode()) % this.buckets.length();
        HashGenCacheSetBucket<T> bucket = this.buckets.get(index);
        if (bucket == null) {
            return false;
        }
        Object gen4Val = bucket.gen4ValRef.get();
        if (gen4Val != null && value.equals(gen4Val)) {
            this.buckets.set(index, new HashGenCacheSetBucket(bucket.gen3ValRef, bucket.gen3Weight, bucket.gen2ValRef, bucket.gen2Weight, bucket.gen1ValRef, bucket.gen1Weight, HashGenCacheSet.nullRef(), 0));
            return true;
        }
        Object gen3Val = bucket.gen3ValRef.get();
        if (gen3Val != null && value.equals(gen3Val)) {
            this.buckets.set(index, new HashGenCacheSetBucket(bucket.gen4ValRef, bucket.gen4Weight, bucket.gen2ValRef, bucket.gen2Weight, bucket.gen1ValRef, bucket.gen1Weight, HashGenCacheSet.nullRef(), 0));
            return true;
        }
        Object gen2Val = bucket.gen2ValRef.get();
        if (gen2Val != null && value.equals(gen2Val)) {
            this.buckets.set(index, new HashGenCacheSetBucket(bucket.gen4ValRef, bucket.gen4Weight, bucket.gen3ValRef, bucket.gen3Weight, bucket.gen1ValRef, bucket.gen1Weight, HashGenCacheSet.nullRef(), 0));
            return true;
        }
        Object gen1Val = bucket.gen1ValRef.get();
        if (gen1Val != null && value.equals(gen1Val)) {
            this.buckets.set(index, new HashGenCacheSetBucket(bucket.gen4ValRef, bucket.gen4Weight, bucket.gen3ValRef, bucket.gen3Weight, bucket.gen2ValRef, bucket.gen2Weight, HashGenCacheSet.nullRef(), 0));
            return true;
        }
        return false;
    }

    public void clear() {
        for (int i = 0; i < this.buckets.length(); ++i) {
            this.buckets.set(i, null);
        }
    }

    public double hitRatio() {
        double hits = (double)GEN4_HITS.get(this) + (double)GEN3_HITS.get(this) + (double)GEN2_HITS.get(this) + (double)GEN1_HITS.get(this);
        return hits / (hits + (double)MISSES.get(this));
    }

    static final <T> SoftReference<T> nullRef() {
        return NULL_REF;
    }

    static final <T> WeakReference<T> weakRef(Reference<T> ref) {
        if (ref instanceof WeakReference) {
            return (WeakReference)ref;
        }
        return new WeakReference<T>(ref.get());
    }
}

